<?php

namespace App\Exports;

use App\Models\UsersKPI;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UserKPISExport implements WithMapping, WithHeadings,FromQuery
{

    public function query()
    {
        $user_kpis=UsersKPI::query()->select('users_kpis.id','users_kpis.kpi_id','kpis.name AS kpi_name','users.name AS user_name','users_kpis.user_id','users_kpis.year','users_kpis.month','users_kpis.total_employee_score','users_kpis.created_at',DB::raw("DATE_FORMAT(CAST(CONCAT(users_kpis.year,'-',users_kpis.month,'-01') AS DATE),'%Y-%m')  AS `year_month`"))->has('KPI')->has('User')
            ->leftJoin('users','users.id','=','users_kpis.user_id')
            ->leftJoin('kpis','kpis.id','=','users_kpis.kpi_id')
        ;
        if(request('IDS')){
            $user_kpis=$user_kpis->whereIn('users_kpis.id',explode(',',request('IDS')));
        }
        return $user_kpis;
    }
    /**
    * @return \Illuminate\Support\Collection
    */

    public function map($user_kpi) : array {
        return [

            $user_kpi->user_name,
            $user_kpi->kpi_name,
            $user_kpi->year_month,
            $user_kpi->total_employee_score,
            $user_kpi->created_at?$user_kpi->created_at->format('d M Y, h:i a'):'',

        ] ;
    }
    public function headings() : array {
        return [
            __('Employee Name'),
            __('KPI Name'),
            __('Year & Month'),
            __('Total Employee Score'),
            __('Created At')
        ] ;
    }
}
