<?php
function PerUser($permission){
    return (auth()->check())?auth()->user()->can($permission):false;
}
function log_admin_changes_action($action,$model){
    $changes = $model->getChanges();
    $skipColumns=['add_date','created_at','updated_at','added_by','created_by','updated_by'];
    //dd($changes,$model->getOriginal());
    $records_change=[];
    $text='';
    foreach ($changes as $key=>$value){
        if(!in_array($key,$skipColumns)){
//            $text.='<li>'."@lang('main.$key') @lang('main.Chage')".." @lang('main.Changed To') ".$value.'</li>';
            $oldVal=$model->getOriginal($key);
            if(is_a($value, 'DateTime')){
                $value=$value->format('Y-m-d H:i:s');
            }
            $text.='<li>'."@lang('main.:key Changed Form :oldVal To :newVal',['key'=>'$key','oldVal'=>'$oldVal','newVal'=>'$value'])</li>";
            $records_change[]=[
                $key=>[
                    'from'=>$model->getOriginal($key),
                    'to'=>$value,
                ]
            ];
        }
    }
    if($text){
        $text='<ul>'.$text.'<ul>';
    }
    if($records_change){
        $createdData=[
            'action'=>$action,
            'table_id'=>$model->id,
            'table_name'=>$model->getTable(),
            'text'=>$text,
            'records_change'=>json_encode($records_change),
            'ip_address'=>request()->ip(),
            'user_agent'=>request()->userAgent(),
            'request_url'=>request()->fullUrl(),
            'request_method'=>request()->method(),
            'request_data'=>json_encode(request()->input()),
            'created_by'=>(auth()->check()?auth()->id():0),
            'created_by_name'=>(auth()->check()?auth()->user()->name:'Automation System'),
            'created_at'=>date('Y-m-d H:i:s'),
        ];
        \App\Models\ModelsChangesLog::create($createdData);
    }

}
function selectSup($cat_id,$selected=0,$y=null,$not_id=0,$col='title',$table=\App\Models\Department::class,$hasRelations=[],$html=''){
    if($y===null){
        $y='&nbsp;&nbsp;';
    }
    $sections=$table::where('parent_id',$cat_id);
    foreach ($hasRelations as $hasRelation){
        $sections=$sections->whereHas($hasRelation);
    }
    $sections=$sections->get();
    foreach ($sections as $section) {
        if($section->id!=$not_id){
            $html.='<option ';
            if($section->id==$selected||(is_array($section)&&in_array($section->id,$section))){$html.='selected="selected"';}
            $html.=' value="'.$section->id.'">'.$y.'⁞.. '.$section->$col.'</option>';
            if($section->parent_id!=0){
                $y.='&nbsp;&nbsp;';
                selectSup($section->id,$selected,$y,$not_id,$col,$table,$hasRelations,$html);
            }
            $y='&nbsp;&nbsp;';
        }
    }
    return $html;
}
function uploadImage($file,$folder_name='users',$input='image',$returnName='image'){
    $path = '/images/' . $folder_name . '/' . date('Y/m/d') . '/';
    if (!file_exists(public_path() . $path)) {
        \Illuminate\Support\Facades\File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    //file new name
    $namefile = $folder_name . '_' . rand(0000, 9999) . '_' . time();
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
    list($width, $height) = getimagesize($_FILES[$input]['tmp_name']);
    $file->move(public_path() . $path, $mastername);
    return[$returnName.'_dir'=>$path,$returnName=>$mastername,
        //'original_image'=>$old_name,'original_width'=>$width,'original_height'=>$height,'original_mimtype'=>$mimtype
    ];
}
function updateModelPath($model,$col='path'){
    $paths = getParentPath($model->id);
    sort($paths);
    $paths = implode('', $paths);
    \Illuminate\Support\Facades\DB::table($model->getTable())->where('id',$model->id)->update([
        $col=>$paths,
    ]);
}
function getParentPath($model_id, $paths = [],$model=\App\Models\User::class)
{
    $parent = $model::find($model_id);
    if ($parent) {
        $paths[] = ':'.$parent->id . '::';
        if ($parent->parent_id) {
            $paths = getParentPath($parent->parent_id, $paths,$model);
        }
    }
    return $paths;
}
function getFirstLetterOfEachWord($string){
    $words = preg_split("/[\s,_-]+/", $string);
    $acronym = "";
    foreach ($words as $w) {
        $acronym .= mb_substr($w, 0, 1);
    }
    return $acronym;
}
function getEloquentSqlWithBindings($query)
{
    return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}
//ini_get('upload_max_filesize')
function return_bytes($val)
{
    $val  = trim($val);

    if (is_numeric($val))
        return $val;

    $last = strtolower($val[strlen($val)-1]);
    $val  = substr($val, 0, -1); // necessary since PHP 7.1; otherwise optional

    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }

    return $val;
}
