<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Department;
use App\Models\JobTitle;
use App\Models\KPI;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request){
        if($request->ajax()){
            $search=$request->search;
            $sections=[
                'roles'=>Role::class,
                'users'=>User::class,
                'departments'=>Department::class,
                'job_titles'=>JobTitle::class,
                'kpis'=>KPI::class,
            ];
            $results=[];
            foreach ($sections as $key=>$class){
                $data=$class::where((in_array($key,['departments','job_titles'])?'title':'name'),'LIKE',"%$search%")->take(5)->pluck((in_array($key,['departments','job_titles'])?'title':'name'),'id')->toArray();
                $dataCount=$class::where((in_array($key,['departments','job_titles'])?'title':'name'),'LIKE',"%$search%")->count();
                if($dataCount){
                    $results[$key]=[
                        'data'=>$data,
                        'count'=>$dataCount,
                    ];
                }
            }
            $html=view('dashboard.include.search_results',compact('results'))->render();
            return response()->json(['success'=>true,'html'=>$html]);
        }
        return view('dashboard.home');
    }
}
