<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Imports\UsersImport;
use App\Models\ImportData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\HeadingRowImport;

class ImportController extends Controller
{
    protected $_configTable=[
        'users'=>[
            'fileValidationHeaders'=>['responsible_employee','department','job_title','name','email','mobile','hiring_date','birth_date','password'],
            'importClass'=>UsersImport::class
        ]
    ];
    protected $_tableName,$_folderName;
    public function __construct()
    {
        $this->_tableName=request()->segment(2);
        $this->_folderName='import_'.request()->segment(2);
    }

    public function uploadFile($file){
        $folder_name=$this->_folderName;
        $path = '/img/'.$folder_name.'/' . date('Y/m/d').'/';
        if (!file_exists(public_path() . $path)) {
            File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
        }
        $namefile = $folder_name.'_' . rand(0000, 9999) . '_' . time();
        $ext = $file->getClientOriginalExtension();
        //file old name
        $old_name = $file->getClientOriginalName();
        $mastername = $namefile . '.' . $ext;
        $file_size=$file->getSize();
        $file_info=$file->getFileInfo();
        $mimtype=$file->getMimeType();
        $file->move(public_path($path), $mastername);
        return [
            'file_dir'=>$path,
            'file_name'=>$mastername,
            'file_old_name'=>$old_name,
            'file_size'=>$file_size,
            'file_info'=>$file_info,
            'file_ext'=>$ext,
            'file_mimtype'=>$mimtype,
        ];
    }
    public function import(Request $request){
        $validator = Validator::make($request->all(),[
            'file'=>'required|mimes:csv,txt,xlsx,xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet|max:'.return_bytes(ini_get('upload_max_filesize')),
        ]);
//        dd($request->file('file')->getMimeType());
        if ($validator->fails()) {
            $messages='';
            foreach($validator->errors()->all() as $error){
                $messages.=$error.' ';
            }
            return response()->json(['success'=>false,'message'=>$messages]);
        }else {
            $file=$request->file('file');
            $fileDataArray=$this->uploadFile($file);
            $fileHeader = (new HeadingRowImport)->toArray(public_path($fileDataArray['file_dir'].$fileDataArray['file_name']))[0][0]; // set csv path here or
            $sameValidation=true;
            foreach ($fileHeader as $item){
                if(!in_array($item,$this->_configTable[$this->_tableName]['fileValidationHeaders'])){
                    $sameValidation=false;
                    break;
                }
            }
            $status=$sameValidation?'imported':'not_same_validation';
            $importData=ImportData::create(array_merge($fileDataArray,['table_name'=>$this->_tableName,'config'=>json_encode($this->_configTable[$this->_tableName]),'is_same'=>$sameValidation,'status'=>$status,'file_header'=>json_encode($fileHeader),'validation_header'=>json_encode($this->_configTable[$this->_tableName]['fileValidationHeaders'])]));
            Excel::import(new $this->_configTable[$this->_tableName]['importClass'](), public_path($importData->file_dir.$importData->file_name));
            if($sameValidation){
                return response()->json(['success'=>true,'message'=>__('Success upload file')]);
            }else{
                return response()->json(['success'=>true,'message'=>__('The file don\'t match the template')]);
            }

        }
    }
}
