<?php

namespace App\Http\Controllers\Dashboard;

use App\DataTables\JobTitlesDataTable;
use App\Exports\JobTitlesExport;
use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use App\Models\JobTitle;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class JobTitlesController extends Controller
{
    //
    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(JobTitlesDataTable $dataTable){
        return $dataTable->render('dashboard.job_titles.index');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //

        return view('dashboard.job_titles.create_edit');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validateJobTitles($request);
        JobTitle::create(array_merge($request->only(['title','status']),['created_by'=>auth()->id()]));
        alert()->success(__('Success'),__('Create Successfully'));
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(JobTitle $job_title)
    {
        //
        return view('dashboard.job_titles.create_edit',compact('job_title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, JobTitle $job_title)
    {
        //
        $this->validateJobTitles($request);
        $updateData=array_merge($request->only('title','status'),['updated_by'=>auth()->id()]);
        $job_title->update($updateData);
        alert()->success(__('Success'),__('Update Successfully'));
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(JobTitle $job_title)
    {
        //
        $job_title->deleted_by=auth()->id();
        $job_title->save();
        $job_title->delete();
        return response()->json(['success'=>true,'message'=>__('Delete Successful')]);
    }

    public function validateJobTitles($request){
        $valid=[

            'status'=>'required|in:'.implode(',',config('app.statusArray')),
        ];
        if($request->job_title){
//            $valid['email']='required|email|unique:job_titles,email,'.$request->job_title->id.',NULL,deleted_at,NULL';
            $valid['title']=['required',Rule::unique('job_titles','title')->whereNull('deleted_at')->ignore($request->job_title->id,'id')];
        }else{
            $valid['title']=['required',Rule::unique('job_titles','title')->whereNull('deleted_at')];
        }
        return $request->validate($valid);
    }
    public function deleteMulti(Request $request){
        $count=JobTitle::whereIn('id',$request->IDS)->update(['deleted_by'=>auth()->id(),'deleted_at'=>now()]);
        return response()->json(['success'=>true,'message'=>__('Delete :count Successful',['count'=>$count])]);
    }
    public function export(Request $request){
        switch ($request->export_type){
            case'csv':
                return Excel::download(new JobTitlesExport,'job_titles_'.time().'.csv',\Maatwebsite\Excel\Excel::CSV);
                break;
            case'excel':
                return Excel::download(new JobTitlesExport,'job_titles_'.time().'.xlsx',\Maatwebsite\Excel\Excel::XLSX);
                break;
            case'pdf':
                $job_titles=JobTitle::query();
                if(request('IDS')){
                    $job_titles=$job_titles->whereIn('id',explode(',',request('IDS')));
                }
                $job_titles=$job_titles->get();
                return Pdf::loadView('dashboard.job_titles.export_pdf',['job_titles'=>$job_titles])->download('job_titles_'.time().'.pdf');
                break;
        }

    }

}
