<?php

namespace App\Imports;

use App\Models\Department;
use App\Models\JobTitle;
use App\Models\User;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class UsersImport  implements ToModel, WithChunkReading,WithHeadingRow
{
    private $match_columns;
    public function __construct($match_columns=[])
    {
        $this->match_columns=$match_columns;
    }

    /**
    * @param Collection $collection
    */
    public function model(array $row)
    {
        //
        if(!$this->match_columns){
            $parent_id=0;
            $department_id=0;
            $job_title_id=0;
            if($row['responsible_employee']){
                if(!$user=User::where('name',$row['responsible_employee'])->first()){
                    $user=User::create([
                        'name'=>$row['responsible_employee'],
                    ]);
                }
                $parent_id=$user->id;
            }
            if($row['department']){
                if(!$department=Department::where('title',$row['department'])->first()){
                    $department=Department::create([
                        'title'=>$row['department'],
                    ]);
                }
                $department_id=$department->id;
            }
            if($row['job_title']){
                if(!$jobTitle=JobTitle::where('title',$row['job_title'])->first()){
                    $jobTitle=JobTitle::create([
                        'title'=>$row['job_title'],
                    ]);
                }
                $job_title_id=$jobTitle->id;
            }

            $createData=[
                'name'=>$row['name'],
                'email'=>$row['email'],
                'mobile'=>$row['mobile'],
            ];

            if($parent_id){
                $createData['parent_id']=$parent_id;
            }
            if($department_id){
                $createData['department_id']=$department_id;
            }
            if($job_title_id){
                $createData['job_title_id']=$job_title_id;
            }
            if($row['password']){
                $createData['password']=Hash::make($row['password']);
            }

            if($row['hiring_date']){
                $createData['hiring_date']=\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['hiring_date']);
            }
            if($row['birth_date']){
                $createData['birth_date']=\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['birth_date']);
            }

            if($user=User::where(function ($q)use($row){$q->where('name',$row['name'])->orWhere('email',$row['email']);})->first()){
                $user->update($createData);
            }else{
                User::create($createData);
            }
        }

    }
    public function chunkSize(): int
    {
        return 1000;
    }
}
