<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasPermissions;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    protected $guarded=['id'];
    use HasApiTokens, HasFactory, Notifiable,HasRoles,HasPermissions,SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
//    protected $fillable = [
//        'name',
//        'email',
//        'password',
//    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'last_login_at' => 'datetime',
    ];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_changes_action('update',$model);
            updateModelPath($model);
        });
        static::created(function ($model) {
            log_admin_changes_action('create',$model);
            updateModelPath($model);
        });
        static::deleted(function ($model) {
            log_admin_changes_action('delete',$model);
        });
    }
    public function Parent(){
        return $this->belongsTo(User::class,'parent_id');
    }
    public function Department(){
        return $this->belongsTo(Department::class,'department_id');
    }
    public function JobTitle(){
        return $this->belongsTo(JobTitle::class,'job_title_id');
    }



}
