<?php

namespace Database\Factories;

use App\Models\JobTitle;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\JobTitle>
 */
class JobTitleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $jobTitle=JobTitle::inRandomOrder()->first();
        return [
            //
            'title'=>fake()->jobTitle,
            'status'=>fake()->randomElement(config('app.statusArray')),
        ];
    }
}
