<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->integer('parent_id')->default(0);
            $table->integer('department_id')->default(0);
            $table->integer('job_title_id')->default(0);
            $table->string('path')->nullable();
            $table->string('name')->nullable();
            $table->date('birth_date')->nullable();
            $table->date('hiring_date')->nullable();
            $table->string('mobile')->nullable();
            $table->string('email');//->unique();
            $table->timestamp('active_at')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->boolean('two_step')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('image')->nullable();
            $table->string('image_dir')->nullable();
            $table->text('google2fa_secret')->nullable();
            $table->integer('google2fa_ts')->nullable();
            $table->string('language')->default('en');
            $table->rememberToken();
            $table->integer('deleted_by')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
