<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;

class RolesAndPermissionsSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        $gardName=config('auth.defaults.guard');
        $permissionsByRole = [
            'admin' => [
                /*roles*/
                'roles.create',
                'roles.edit',
                'roles.destroy',
                'roles.index',
                'roles.export',
                'roles.import',
                /*users*/
                'users.create',
                'users.edit',
                'users.destroy',
                'users.index',
                'users.export',
                'users.import',
                /*departments*/
                'departments.create',
                'departments.edit',
                'departments.destroy',
                'departments.index',
                'departments.export',
                'departments.import',

                /*job_titles*/
                'job_titles.create',
                'job_titles.edit',
                'job_titles.destroy',
                'job_titles.index',
                'job_titles.export',
                'job_titles.import',

                /*employees*/
                'employees.create',
                'employees.edit',
                'employees.destroy',
                'employees.index',
                'employees.export',
                'employees.import',
                /*kpis*/
                'kpis.create',
                'kpis.edit',
                'kpis.destroy',
                'kpis.index',
                'kpis.export',
                'kpis.import',

                /*settings*/
                /*kpis*/
                'users_kpis.create',
                'users_kpis.edit',
                'users_kpis.destroy',
                'users_kpis.index',
                'users_kpis.export',
                'users_kpis.import',
                'users_kpis.show_all',
                'users_kpis.report',
                'users_kpis.total_report',

                /*settings*/
                'settings.index',
            ],
        ];


        $insertPermissions = fn ($role) => collect($permissionsByRole[$role])
            ->map(fn ($name) => DB::table(config('permission.table_names.permissions'))->insertGetId(['name' => $name,'group'=>ucfirst(explode('.',str_replace('_',' ',$name))[0]), 'guard_name' => $gardName,'created_at'=>now(),]))
            ->toArray();

        $permissionIdsByRole = [
            'admin' => $insertPermissions('admin'),
        ];

        foreach ($permissionIdsByRole as $roleName => $permissionIds) {
            $role = Role::whereName($roleName)->first();
            if(!$role){
                $role=Role::create([
                    'name'=>$roleName,
                    'description'=>'Best for business owners and company administrators',
                    'guard_name'=>$gardName,
                    'created_at'=>now(),
                ]);
            }
            DB::table(config('permission.table_names.role_has_permissions'))
                ->insert(
                    collect($permissionIds)->map(fn ($id) => [
                        'role_id' => $role->id,
                        'permission_id' => $id,
                    ])->toArray()
                );
            $user=User::where('name',$roleName)->first();
            if($user){
                $user->assignRole($role);
                //$user->givePermissionTo(DB::table('permissions')->whereIn('id',$permissionIds)->pluck('name')->toArray());
            }
        }
    }
}
