@extends('dashboard.layouts.app')
@push('headScripts')
@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Departments & Job Titles') }} /</span> <a href="{{ route('departments.index') }}" class="text-muted fw-light">{{ __('Departments') }} /</a> {{ (isset($department))?__('Edit :type',['type'=>$department->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ (isset($department))?__('Edit :type',['type'=>$department->name]):__('Create') }}</h5>
                    <form method="POST" action="{{ isset($department)?route('departments.update',['department'=>$department]):route('departments.store') }}" enctype="multipart/form-data">
                        @if(isset($department))
                            @method('PUT')
                        @endif
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-lg-12 mb-3">
                                    <label class="form-label">{{ __('Title') }}</label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror border-left-0" name="title" id="title" value="{{ isset($department)?$department->title:old('title') }}" placeholder="{{ __('Enter :value',['value'=>__('Department Title')]) }}">
                                    @error('title')
                                    <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                    @enderror

                                </div>
                                <div class="btn-group" role="group" aria-label="Basic radio toggle button group">
                                    @foreach(config('app.statusArray') as $key=>$status)
                                    <input type="radio" class="btn-check" name="status" id="status-{{ $key+1 }}" {{ (isset($department)&&$department->status==$status)||(old('status')&&old('status')==$status)||(!isset($department)&&!old('status')&&$status==config('app.defaultStatusSelected'))?'checked':'' }} value="{{ $status }}"  autocomplete="off">
                                        <label class="btn btn-outline-{{ config('app.statusButtonClass')[$status] }}" for="status-{{ $key+1 }}">{{ ucfirst($status) }}</label>
                                    @endforeach

                                </div>
                                @error('status')
                                <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="text-center mt-3">
                            <button type="submit" class="btn btn-danger px-5">{{ __('Save') }}</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script src="{{ asset('js/permissions_table.js') }}"></script>
@endpush
