@extends('dashboard.layouts.app')
@push('headScripts')
@endpush
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">{{ __('Users & Roles') }} /</span> <a href="{{ route('users.index') }}" class="text-muted fw-light">{{ __('Users') }} /</a> {{ (isset($user))?__('Edit :type',['type'=>$user->name]):__('Create') }}</h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <h5 class="card-header">{{ (isset($user))?__('Edit :type',['type'=>$user->name]):__('Create') }}</h5>
                    <form method="POST" action="{{ isset($user)?route('users.update',['user'=>$user]):route('users.store') }}" enctype="multipart/form-data">
                        @if(isset($user))
                            @method('PUT')
                        @endif
                        @csrf
                        <div class="card-body">
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="@if(isset($user)&&$user->image_dir){{ asset($user->image_dir.$user->image) }}@else{{ config('app.default_user_image') }}@endif" alt="user-avatar" class="d-block rounded" height="100" width="100" id="uploadedAvatar">
                                <div class="button-wrapper">
                                    <label for="upload" class="btn btn-primary me-2 mb-4" tabindex="0">
                                        <span class="d-none d-sm-block">{{ __('Upload new photo') }}</span>
                                        <i class="bx bx-upload d-block d-sm-none"></i>
                                        <input type="file" id="upload" class="account-file-input" name="image" hidden="" accept="image/png, image/jpeg">
                                    </label>
                                    <button type="button" class="btn btn-outline-secondary account-image-reset mb-4">
                                        <i class="bx bx-reset d-block d-sm-none"></i>
                                        <span class="d-none d-sm-block">{{ __('Reset') }}</span>
                                    </button>

                                    <p class="text-muted mb-0">{{ __('Allowed JPG, GIF or PNG. Max size of 800K') }}</p>
                                </div>
                            </div>
                        </div>
                            <hr class="mb-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-lg-4 mb-3">
                                    <label class="form-label">{{ __('Parent') }} <span class="badge bg-info">{{ __('Responsible Employee') }}</span></label>
                                    @php($user=isset($user)?$user:null)
                                    <select class="select2 @error('parent_id') is-invalid @enderror" data-placeholder="{{ __('Select :type',['type'=>__('Responsible Employee')]) }}" name="parent_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Responsible Employee')]) }}</option>
                                        @foreach(\App\Models\User::where(function ($q)use($user){$q->where('parent_id',0)->where('id','!=',(isset($user)?$user->id:0));})->pluck('name','id')->toArray() as $id=>$name)
                                            <option @if((isset($user)&&$user->parent_id==$id)||old('parent_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                            {!! selectSup($id,(isset($user)?$user->parent_id:old('parent_id')),null,(isset($user)?$user->id:0),'name',\App\Models\User::class) !!}
                                        @endforeach
                                    </select>
                                    @error('parent_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-4 mb-3">
                                    <label class="form-label">{{ __('Departments') }}</label>
                                    <select class="select2 @error('department_id') is-invalid @enderror" data-placeholder="{{ __('Select :type',['type'=>__('Department')]) }}" name="department_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Department')]) }}</option>
                                        @foreach(\App\Models\Department::pluck('title','id')->toArray() as $id=>$name)
                                            <option @if((isset($user)&&$user->department_id==$id)||old('department_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('department_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-4 mb-3">
                                    <label class="form-label">{{ __('Job Titles') }}</label>
                                    <select class="select2 @error('job_title_id') is-invalid @enderror" data-placeholder="{{ __('Select :type',['type'=>__('Job Title')]) }}" name="job_title_id">
                                        <option value="">{{ __('Select :type',['type'=>__('Job Title')]) }}</option>
                                        @foreach(\App\Models\JobTitle::pluck('title','id')->toArray() as $id=>$name)
                                            <option @if((isset($user)&&$user->job_title_id==$id)||old('job_title_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('job_title_id')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-12 mb-3">
                                    <label class="form-label">{{ __('Roles') }}</label>
                                    <select class="select2 @error('role_id') is-invalid @enderror" multiple data-placeholder="{{ __('Select :type',['type'=>__('Role')]) }}" name="role_id[]">
                                        @foreach(\Spatie\Permission\Models\Role::pluck('name','id')->toArray() as $id=>$name)
                                            <option @if(isset($user)&&in_array($id,$user->roles()->pluck('id')->toArray())) selected="selected" @elseif(old('role_id')&&in_array($id,old('role_id'))) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('role_id')
                                    <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Name') }}</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror border-left-0" name="name" id="name" value="{{ isset($user)?$user->name:old('name') }}" placeholder="{{ __('Enter :value',['value'=>__('User Name')]) }}">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                    @enderror

                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Email Address') }}</label>
                                    <input type="email" autocomplete="new-email" class="form-control @error('email') is-invalid @enderror border-left-0" name="email" id="email" value="{{ isset($user)?$user->email:old('email') }}" placeholder="{{ __('Enter :value',['value'=>__('Email Address')]) }}">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Mobile') }}</label>
                                    <input type="tel" class="form-control number-only @error('mobile') is-invalid @enderror border-left-0" name="mobile" id="mobile" value="{{ isset($user)?$user->mobile:old('mobile') }}" placeholder="{{ __('Enter :value',['value'=>__('Mobile')]) }}">
                                    @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Hiring Date') }}</label>
                                    <input type="date"  min="1990-01-01" max="{{ date('Y-m-d') }}" class="form-control @error('hiring_date') is-invalid @enderror border-left-0" name="hiring_date" id="hiring_date" value="{{ isset($user)?$user->hiring_date:old('hiring_date') }}" placeholder="{{ __('Enter :value',['value'=>__('Hiring Date')]) }}">
                                    @error('hiring_date')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Birth Date') }}</label>
                                    <input type="date" min="1930-01-01" max="{{ date('Y-m-d') }}"  class="form-control @error('birth_date') is-invalid @enderror border-left-0" name="birth_date" id="birth_date" value="{{ isset($user)?$user->birth_date:old('birth_date') }}" placeholder="{{ __('Enter :value',['value'=>__('Birth Date')]) }}">
                                    @error('birth_date')
                                    <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-6 mb-3">
                                    <label class="form-label">{{ __('Password') }} @if(isset($user)) <span class="badge bg-info">{{ __('You can fill it if you need to change password') }}</span> @endif</label>
                                    <input type="password" autocomplete="new-password" class="form-control @error('password') is-invalid @enderror border-left-0" name="password" id="password" placeholder="{{ __('Enter :value',['value'=>__('Password')]) }}">
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

{{--                                @include('dashboard.include.permissions_table')--}}
                            </div>
                        </div>
                        <div class="text-center mt-3">
                            <button type="submit" class="btn btn-danger px-5">{{ __('Save') }}</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('footerScripts')
    <script>
        let defaultPreviewImg=$("#uploadedAvatar").attr('src');
        $(document).on('change','[name="image"]',function(){
            let previewImg=$(this).parent().parent().parent().find('img');
            let file=this.files[0];
            if(file){
                var reader = new FileReader();
                reader.onload = function(){
                    previewImg.attr("src", reader.result);
                }
                reader.readAsDataURL(file);
            }
        });
        $(document).on('click','.account-image-reset',function(){
            $("#uploadedAvatar").attr('src',defaultPreviewImg);
            $('[name="image"]').val('');
        })
    </script>
@endpush
