<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Auth;

class Admin extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $softDelete = true;
    protected $table = 'system_users';
    protected $guard = 'admin';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username','profile_id','name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    public function Profile(){
        return $this->belongsTo('App\Profiles','profile_id');
    }

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
