<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class CouponsUsed extends Model
{
    //
    protected $table='coupons_used';
    use SoftDeletes;
    protected $guarded=[];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
            Coupons::where('id',$model->coupon_id)->update(['used'=>DB::raw( 'used+1' )]);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
