<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Education extends Model
{
    public function therapist()
    {
        return $this->belongsTo(Therapist::class,'therapist_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action('update',$model);
        });
        static::created(function ($model) {
            log_admin_action('create',$model);
        });
        static::deleted(function ($model) {
            log_admin_action('delete',$model);
        });
    }
}
