<?php

namespace App\Exports;

use App\Payments;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class PaymentsExport implements FromCollection,WithMapping,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Payments::with('sessions','sessions.therapist','sessions.therapist.user','user')->get();
    }
    public function headings(): array
    {
        return [
            'Therapist',
            'Patients',
            'Session Date Time',
            'Session Done',
            'Session_Real_OR_Test',
            'Status',
            'Price',
            'Therapist Amount,',
            'Payment Method',
            'Created at',
        ];
    }
    public function map($payment): array
    {
        $website_percentage=getAppSetting('website_percentage');
        $minimum_price_30=getAppSetting('minimum_price_30');
        $minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
        $minimum_price_60=getAppSetting('minimum_price_60');
        $minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
        if(!isset($payment->sessions->type)){
            $therapistAmount=0;
        }else{
            $minimum_price= 0;
            if(in_array($payment->sessions->type,[30,3,10])){
                if($payment->currancy=='EGP'){
                    $minimum_price=$minimum_price_30;
                }else{
                    $minimum_price=$minimum_price_30_dolar;
                }
            }
            if(in_array($payment->sessions->type,[60,6,15])){
                if($payment->currancy=='EGP'){
                    $minimum_price=$minimum_price_60;
                }else{
                    $minimum_price=$minimum_price_60_dolar;
                }
            }

            if($payment->discount_amount > 0)
            {
                $dis = ($payment->discount_amount / 2);
                $therapistAmount= calculateTherapistAmount(($payment->currancy=='EGP'?$payment->price:$payment->price_dolar),$website_percentage,$minimum_price) + $dis;
            }
            else
            {
                $therapistAmount= calculateTherapistAmount(($payment->currancy=='EGP'?$payment->price:$payment->price_dolar),$website_percentage,$minimum_price);
            }

        }
        return [
            (isset($payment->sessions->therapist->user))?$payment->sessions->therapist->user->name:'',
            ($payment->user)?$payment->user->name:'',
            (isset($payment->sessions->start_time))?$payment->sessions->start_time:'',

            (isset($payment->sessions->therapist_start_date))?'تمت الجلسة':' لم تتم بعد ',

            (isset($payment->sessions->topic)  && $payment->sessions->topic == 'test')?'Test':'Real',
            ($payment->status == 200 ? 'approved' : ($payment->status == 203 ? 'failed' : $payment->status)),
            ($payment->currancy=='EGP'?$payment->price:$payment->price_dolar).' '.$payment->currancy,
            (isset($payment->sessions->therapist_start_date)) ?  ((($therapistAmount>0)?$therapistAmount:0).' '.$payment->currancy) : '',
            $payment->payment_method,
            $payment->created_at,

        ];
    }
    public function properties(): array
    {
        return [
            'creator'        => 'NewHayah',
            'lastModifiedBy' => 'NewHayah',
            'title'          => 'Payment Export',
            'description'    => 'Latest Payments',
            'subject'        => 'Payments',
            'keywords'       => 'Payments,export,spreadsheet',
            'category'       => 'Payments',
            'manager'        => 'NewHayah',
            'company'        => 'NewHayah',
        ];
    }
}
