<?php

namespace App\Exports;

use App\Therapist;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class TherapistsExport implements FromCollection,WithMapping,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Therapist::with('user')->get();
    }
    public function headings(): array
    {
        return [
            'ID',
            'Username',
            'Name',
            'Image',
            'Job Title (English)',
            'Job Title (Arabic)',
            'Email',
            'Active',
            'USD 30',
            'USD 60',
            'EGP 30',
            'EGP 60',
        ];
    }
    public function map($therapist): array
    {
        return [
            $therapist->id,
            ($therapist->user)?$therapist->user->name:'',
            ($therapist->user)?$therapist->name_a:'',
            asset('avatars/therapists/' . $therapist->picture) ,
            $therapist->main_specialty_en,
            $therapist->main_specialty_ar,
            ($therapist->user)?$therapist->user->email:'',
            ($therapist->active==1)?'Active':'Un Active',
            $therapist->thirty_price_dollar,
            $therapist->sixty_price_dollar,
            $therapist->price30,
            $therapist->price60,

        ];
    }
    public function properties(): array
    {
        return [
            'creator'        => 'NewHayah',
            'lastModifiedBy' => 'NewHayah',
            'title'          => 'Payment Export',
            'description'    => 'Latest Payments',
            'subject'        => 'Payments',
            'keywords'       => 'Payments,export,spreadsheet',
            'category'       => 'Payments',
            'manager'        => 'NewHayah',
            'company'        => 'NewHayah',
        ];
    }
}
