<?php

namespace App\Http\Controllers\Admin;

use App\Blog;
use App\WebsiteLanguages;
use App\Profiles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminBlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /*  $search=$request->input('search');
        if($search){
            $blogs=Blog::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $blogs=Blog::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.blogs.view',compact('blogs'));
*/

        if ($request->ajax()) {

            $blogs = Blog::orderBy('id', 'DESC');


            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $blogs = $blogs->where('active', 1);
                        break;
                    case 'unactive':
                        $blogs = $blogs->where('active', 0);
                        break;
                }
            }

            return DataTables::of($blogs)
                ->addIndexColumn()


                ->editColumn('picture', function ($blog) {
                    return '<img style="height: 100px;width: 100px;" src="' . asset($blog->picture) . '"   alt="">';
                })

                ->addColumn('active', function ($blog) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $blog->id . '" type="checkbox" ' . (!PerUser('blogs_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('blogs_active') ? 'changeStatues' : '') . '"  ' . (($blog->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $blog->id . '"><label for="checkbox-' . $blog->id . '"></label></div>';
                })
                ->addColumn('action', function ($blog) {
                    return '
            ' . (PerUser('blogs_edit') ? '<a class="btn btn-success" href="' . URL('admin/blogs/' . $blog->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
            ' . (PerUser('blogs_delete') ? '<a class="btn btn-danger" href="' . URL('blogs_delete/'. $blog->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
            ';
                })

                ->rawColumns(['active', 'action', 'picture'])
                ->make(true);
        }
        return view('admin.blogs.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default', 'desc')->get();
        return view('admin.blogs.add', compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'title' => 'required',
                'description' => 'required',
                'title_en' => 'required',
                'description_en' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $blogs = new Blog();
            $blogs->title = $data['title'];
            $blogs->description = $data['description'];
            $blogs->title_en = $data['title_en'];
            $blogs->description_en = $data['description_en'];
            if ($request->hasFile('picture')) {
                $validator = Validator::make($request->all(), array(
                    'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                } else {
                    $file = $request->file('picture');
                    $image = FileImage($file, 'Blogs/', 'picture');
                    $blogs->picture = $image['img'];
                }
            }
            $blogs->active = $active;
            $blogs->user_id = Auth::user()->id;
            $blogs->created_at = date("Y-m-d H:i:s");
            if ($blogs->save()) {
                //                save_all_trans($data,$blogs->id,'blogs',['title'=>'titles','description'=>'descriptions']);
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.blogs'));
                return Redirect::to('admin/blogs/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id, 'blogs');
        $blog = Blog::find($id);
        if (!empty($blog)) {
            return view('admin.blogs.edit', compact('blog', 'languages'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $blogs = Blog::find($id);
        if (!empty($blogs)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'title' => 'required',
                    'description' => 'required',
                    'title_en' => 'required',
                    'description_en' => 'required',
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                if ($request->hasFile('picture')) {
                    $validator = Validator::make($request->all(), array(
                        'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    } else {
                        if (file_exists(public_path() . $blogs->img_dir . $blogs->img) && !empty($blogs->img_dir)) {
                            unlink(public_path() . $blogs->img_dir . $blogs->img);
                        }
                        $file = $request->file('picture');
                        $image = FileImage($file, 'Blogs/');
                        $blogs->picture = $image['img'];
                    }
                }
                $active = (isset($data['active'])) ? 1 : 0;
                $blogs->title = $data['title'];
                $blogs->description = $data['description'];
                $blogs->title_en = $data['title_en'];
                $blogs->description_en = $data['description_en'];
                $blogs->active = $active;
                $blogs->user_id = Auth::user()->id;
                $blogs->updated_at = date("Y-m-d H:i:s");
                if ($blogs->save()) {
                    //                    save_all_trans($data,$id,'blogs',['title'=>'titles','description'=>'descriptions']);
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.blogs'));
                    return Redirect::to('admin/blogs/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $blogs = Blog::find($id);
        if (!empty($blogs)) {
            //            $blogs->deleted_by=Auth::user()->id;
            $blogs->save();
            if ($blogs->delete()) {
                Session::flash('success', Lang::get('main.blogs') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/blogs');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $blog = Blog::find($id);
            if ($active == 0) {
                $blog->active = 0;
            } elseif ($active == 1) {
                $blog->active = 1;
            }
            $blog->save();
        } else {
            return redirect(404);
        }
    }
}
