<?php

namespace App\Http\Controllers\Admin;

use App\Certificates;
use App\WebsiteLanguages;
use App\Therapist;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminCertificateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /* $search=$request->input('search');
        if($search){
            $certificates=Certificates::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $certificates=Certificates::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.certificates.view',compact('certificates'));*/


        if ($request->ajax()) {

            $certificates = Certificates::with('therapist')->orderBy('id', 'DESC');



            return DataTables::of($certificates)
                ->addIndexColumn()


                ->addColumn('action', function ($certificate) {
                    return '
                    ' . (PerUser('certificates_edit') ? '<a class="btn btn-success" href="' . URL('admin/certificates/' . $certificate->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
                    ' . (PerUser('certificates_delete') ? '<a class="btn btn-danger" href="' . URL('certificates_delete/'. $certificate->id)  . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                    ';
                })

                ->rawColumns(['action'])
                ->make(true);
        }
        return view('admin.certificates.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $therapists = Therapist::pluck('title', 'id');
        return view('admin.certificates.add', compact('therapists'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'name_en' => 'required',
                'organization_en' => 'required',
                //                'therapist_id'=>'required',
                'start_date' => 'required',
                'end_date' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $certificates = new Certificates();
            $certificates->name_ar = $data['name_ar'];
            $certificates->name_en = $data['name_en'];
            $certificates->organization_ar = $data['organization_ar'];
            $certificates->organization_en = $data['organization_en'];
            //            $certificates->therapist_id=$data['therapist_id'];
            $certificates->start_date = date('Y-m-d', strtotime($data['start_date']));
            $certificates->end_date = date('Y-m-d', strtotime($data['end_date']));
            $certificates->created_at = date("Y-m-d H:i:s");
            if ($certificates->save()) {
                //                save_all_trans($data,$certificates->id,'certificates',['name'=>'names','organization'=>'organizations']);
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.certificates'));
                return Redirect::to('admin/certificates/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Certificates  $certificate
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Certificates  $certificate
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $certificate = Certificates::find($id);
        $therapists = Therapist::pluck('title', 'id');
        //        $languages = get_language_trans($id,'certificates');
        if (!empty($certificate)) {
            return view('admin.certificates.edit', compact('certificate', 'therapists'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Certificates  $certificate
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $certificates = Certificates::find($id);
        if (!empty($certificates)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'name_en' => 'required',
                    'organization_en' => 'required',
                    //                    'therapist_id'=>'required',
                    'start_date' => 'required',
                    'end_date' => 'required',
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                $certificates->name_ar = $data['name_ar'];
                $certificates->name_en = $data['name_en'];
                $certificates->organization_ar = $data['organization_ar'];
                $certificates->organization_en = $data['organization_en'];
                //                $certificates->therapist_id=$data['therapist_id'];
                $certificates->start_date = date('Y-m-d', strtotime($data['start_date']));
                $certificates->end_date = date('Y-m-d', strtotime($data['end_date']));
                $certificates->updated_at = date("Y-m-d H:i:s");
                if ($certificates->save()) {
                    //                    save_all_trans($data,$id,'certificates',['name'=>'names','organization'=>'organizations']);
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.certificates'));
                    return Redirect::to('admin/certificates/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Certificates  $certificate
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $certificates = Certificates::find($id);
        if (!empty($certificates)) {
            $certificates->save();
            if ($certificates->delete()) {
                Session::flash('success', Lang::get('main.certificates') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/certificates');
            }
        }
    }
}
