<?php

namespace App\Http\Controllers\Admin;

use App\Complain;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
class AdminClientComplaintsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /*return view('admin.complaints.view')->with('allComplaints',Complain::all());*/

        if ($request->ajax()) {

            $allComplaints=Complain::with('User');



           return DataTables::of($allComplaints)
               ->addIndexColumn()



               ->addColumn('active', function ($allComplaints) {
               })


               ->addColumn('action', function ($allComplaints) {
                return '
                ' . (PerUser('contact_delete') ? '<a class="btn btn-danger" href="' . URL('contact_delete/'. $allComplaints->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                ';
            })
               ->rawColumns([ 'action'])
               ->make(true);
       }
       return view('admin.complaints.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $complain = Complain::findOrFail($id);
        !empty($complain) ?  $complain->delete():'';
        return response()->json(' Complain Deleted Successfully');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $complain = Complain::findOrFail($id);
        !empty($complain) ?  $complain->delete():'';
        return response()->json(' Complain Deleted Successfully');
    }
}
