<?php

namespace App\Http\Controllers\Admin;
use App\Contact;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
class AdminContactController extends Controller
{

    public function index(Request $request)
    {
    /*    $allContacts = Contact::all();
        return view('admin.contacts.view',compact('allContacts'));*/

        if ($request->ajax()) {

            $allContacts=Contact::orderBy('id','DESC');



           return DataTables::of($allContacts)
               ->addIndexColumn()



               ->addColumn('active', function ($allContacts) {
               })


               ->addColumn('action', function ($allContacts) {
                return '
                ' . (PerUser('complaint_delete') ? '<a class="btn btn-danger" href="' . URL('complaint_delete/'. $allContacts->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                ';
            })
               ->rawColumns([ 'action'])
               ->make(true);
       }
       return view('admin.contacts.view');

    }
    public function destroy ($id)
    {
        $contact = Contact::findOrFail($id);
        !empty( $contact) ?   $contact->delete():'';
        return response()->json('Contact Deleted Successfully');
    }
}
