<?php

namespace App\Http\Controllers\Admin;

use App\AppSettings;
use App\Profiles;
use App\Therapist;
use App\Visitor;
use App\User;
use App\Payments;
use App\SystemSettings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminController extends Controller
{
    //
    public function __construct()
    {

        $this->middleware('auth');
    }
    public function home(Request $request)
    {



        $profiles = Profiles::all();
        $therapist = Therapist::with('sessions')->take(20)->get();
        $visitor = Visitor::with('user')->with('sessions')->take(20)->get();
        $user = User::all();

        $payments = Payments::with('user')->with('sessions')->with('therapist')->take(20)->get();
        $allpayment = 0;

        return view('admin.home', compact('profiles', 'therapist', 'visitor', 'user', 'payments', 'allpayment'));
    }
    public function profile()
    {
        return view('admin.users.profile');
    }
    public function profilePost(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'name' => 'required',
                'email' => 'required|unique:users,email,' . Auth::id(),
                'username' => 'required|unique:users,username,' . Auth::id(),
                'old_password' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            if (Hash::check($request->input('old_password'), Auth::user()->password)) {
                $user = User::find(Auth::user()->id);
                if ($request->hasFile('image')) {
                    $rules = array('image' => 'required|image|mimes:jpg,jpeg,gif,bmp,png');
                    $validator = Validator::make(array('image' => $request->file('image')), $rules);
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }
                    if (file_exists(public_path() . $user->img_dir . $user->img)) {
                        unlink(public_path() . $user->img_dir . $user->img);
                    }
                    if (file_exists(public_path() . $user->img_dir . 'thumbnail/thumbnail_' . $user->img)) {
                        unlink(public_path() . $user->img_dir . 'thumbnail/thumbnail_' . $user->img);
                    }
                    $file = $request->file('image');
                    $image = FileImage($file, 'Users');
                    $user->img = $image['img'];
                    $user->img_dir = $image['img_dir'];
                }
                $user->name = $request->input('name');
                $user->username = $request->input('username');
                $user->email = $request->input('email');
                if (!empty($request->input('new_password'))) {
                    $user->password = Hash::make($request->input('new_password'));
                }
                if ($user->save()) {
                    Session::flash('success', Lang::get('main.updated'));
                    return Redirect::to('admin/profile');
                }
            } else {
                Session::flash('error', Lang::get('main.error_user_password'));
                return Redirect::to('admin/profile');
            }
        }
    }
    public function system()
    {
        $system = SystemSettings::where('user_id', Auth::user()->id)->first();
        if (empty($system)) {
            $system = new SystemSettings();
            $system->user_id = Auth::user()->id;
            $system->save();
        }
        return view('admin.settings.system', compact('system'));
    }
    public function systemPost(Request $request)
    {
        $system = SystemSettings::where('user_id', Auth::user()->id)->first();
        if (empty($system)) {
            $system = new SystemSettings();
            $system->user_id = Auth::user()->id;
            $system->save();
        }

        $data = $request->input();;
        $validator = Validator::make(
            $request->all(),
            array(
                'backend_lang' => 'required',
                'backend_color' => 'required',
                'backend_layout' => 'required',
                'backend_header' => 'required',
                'backend_top_menu_dropdown' => 'required',
                'backend_sidebar_menu_mode' => 'required',
                /*'backend_sidebar_menu_sub_show'=>'required',*/
                'backend_sidebar_menu_style' => 'required',
                'backend_sidebar_menu_position' => 'required',
                'backend_footer' => 'required',

            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $system->backend_lang = $data['backend_lang'];
            $system->backend_color = $data['backend_color'];
            $system->backend_layout = $data['backend_layout'];
            $system->backend_header = $data['backend_header'];
            $system->backend_top_menu_dropdown = $data['backend_top_menu_dropdown'];
            $system->backend_sidebar_menu_mode = $data['backend_sidebar_menu_mode'];
            /*$system->backend_sidebar_menu_sub_show=$data['backend_sidebar_menu_sub_show'];*/
            $system->backend_sidebar_menu_style = $data['backend_sidebar_menu_style'];
            $system->backend_sidebar_menu_position = $data['backend_sidebar_menu_position'];
            $system->backend_footer = $data['backend_footer'];
            $system->lastedit_by = Auth::user()->id;
            $system->lastedit_date = date('Y-m-d H:i:s');
            if ($system->save()) {
                Session::flash('success', Lang::get('main.updated'));
                return Redirect::to('admin/system');
            }
        }
    }


    public function therapistdatatable(Request $request)
    {

        if ($request->ajax()) {

            $therapists = Therapist::with('sessions')->with('user')->take(20);

            return DataTables::of($therapists)
                ->addIndexColumn()
                ->addColumn('countofsessions', function ($therapists) {
                    return count($therapists->sessions);
                })
                ->addColumn('reset', function ($therapists) {
                    return ' ' . (PerUser('therapists_reset') ? '<a class="btn btn-primary" href="' . URL('therapists_reset/'. $therapists->user_id) . '"><i class="fa fa-key"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '';
                })
                ->rawColumns(['countofsessions','reset'])
                ->make(true);
        }
        return view('admin.therapists.view');
    }

    public function visitorsdash(Request $request)
    {

        if ($request->ajax()) {




        $visitors = User::with('visitor')->take(20);




            return DataTables::of($visitors)

                ->addIndexColumn()
                ->addColumn('visitorname', function ($visitor) {


                        return $visitor->name;

                })
                ->addColumn('countofsessions', function ($visitor) {

                    if ($visitor->visitor != null) {
                        return count($visitor->visitor->sessions);
                    }else{
                        return 0;
                    }
                })
                ->addColumn('reset', function ($visitor) {
                    return ' ' . (PerUser('visitors_reset') ? '<a class="btn btn-primary" href="' . URL('visitors_reset/'. $visitor->id) . '"><i class="fa fa-key"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '';
                })
                ->rawColumns(['visitorname','countofsessions','reset'])
                ->make(true);
        }
        return view('admin.visitorsdash');
    }

    public function paymentsdash(Request $request)
    {

        if ($request->ajax()) {


            $payments = Payments::with('user')->with('sessions')->with('therapist')->take(20);

            return DataTables::of($payments)
                ->addIndexColumn()

                ->make(true);
        }
        return view('admin.therapists.view');
    }
    public function appSettings(){
        $appSettings=AppSettings::get();
        return view('admin.settings.app_settings',compact('appSettings'));
    }
    public function appSettingsPost(Request $request){
        foreach ($request->app_settings as $id=>$value){
            AppSettings::where('id',$id)->update(['value'=>$value]);
        }
        Session::flash('success', Lang::get('main.updated'));
        return Redirect::to('admin/app_settings');
    }
}
