<?php

namespace App\Http\Controllers\Admin;

use App\Countries;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminCountryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       /* $search=$request->input('search');
        if($search){
            $countries=Countries::where('title_ar','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $countries=Countries::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.countries.view',compact('countries'));*/
        if ($request->ajax()) {

            $countries=Countries::orderBy('id','DESC');

           return DataTables::of($countries)
               ->addIndexColumn()

               ->addColumn('action', function ($countries) {
                   return '
           ' . (PerUser('countries_edit') ? '<a class="btn btn-success" href="' . URL('admin/countries/' . $countries->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('countries_delete') ? '<a class="btn btn-danger" href="' . URL('countries_delete/'. $countries->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.countries.view');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Countries::orderBy('id','desc')->get();
        return view('admin.countries.add',compact('countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'title_ar'=>'required',
                'title_en'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $countries=new Countries();
            $countries->title_ar=$data['title_ar'];
            $countries->title_en=$data['title_en'];
            $countries->created_at=date("Y-m-d H:i:s");
            if($countries->save()){
//                save_all_trans($data,$countries->id,'countries',['title'=>'titles']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.countries'));
                return Redirect::to('admin/countries/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Countries  $country
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Countries  $country
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id,'countries');
        $country=Countries::find($id);
        if(!empty($country)){
            return view('admin.countries.edit',compact('country','languages'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Countries  $country
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $countries= Countries::find($id);
        if(!empty($countries)){
            $validator = Validator::make($request->all(),
                array(
                    'title_ar'=>'required',
                    'title_en'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $countries->title_ar=$data['title_ar'];
                $countries->title_en=$data['title_en'];
                $countries->updated_at=date("Y-m-d H:i:s");
                if($countries->save()){
//                    save_all_trans($data,$id,'countries',['title'=>'titles']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.countries'));
                    return Redirect::to('admin/countries/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Countries  $country
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $countries=Countries::find($id);
        if(!empty($countries)){
//            $countries->deleted_by=Auth::user()->id;
            $countries->save();
            if($countries->delete()){
                Session::flash('success', Lang::get('main.countries') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/countries');
            }
        }
    }
}
