<?php

namespace App\Http\Controllers\Admin;

use App\Education;
use App\WebsiteLanguages;
use App\Therapist;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AdminEducationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $search=$request->input('search');
        if($search){
            $educations=Education::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $educations=Education::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.educations.view',compact('educations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $therapists = Therapist::pluck('title','id');
        return view('admin.educations.add',compact('therapists'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'name_en'=>'required',
                'organization_en'=>'required',
//                'therapist_id'=>'required',
                'start_date'=>'required',
                'end_date'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $educations=new Education();
            $educations->name_ar=$data['name_ar'];
            $educations->name_en=$data['name_en'];
            $educations->organization_ar=$data['organization_ar'];
            $educations->organization_en=$data['organization_en'];
//            $educations->therapist_id=$data['therapist_id'];
            $educations->start_date=date('Y-m-d',strtotime($data['start_date']));
            $educations->end_date=date('Y-m-d',strtotime($data['end_date']));
            $educations->created_at=date("Y-m-d H:i:s");
            if($educations->save()){
//                save_all_trans($data,$educations->id,'educations',['name'=>'names','organization'=>'organizations']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.educations'));
                return Redirect::to('admin/educations/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Education  $education
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Education  $education
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $education=Education::find($id);
        $therapists = Therapist::pluck('title','id');
        if(!empty($education)){
            return view('admin.educations.edit',compact('education','therapists'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Education  $education
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $educations= Education::find($id);
        if(!empty($educations)){
            $validator = Validator::make($request->all(),
                array(
                    'name_en'=>'required',
                    'organization_en'=>'required',
//                    'therapist_id'=>'required',
                    'start_date'=>'required',
                    'end_date'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $educations->name_ar=$data['name_ar'];
                $educations->name_en=$data['name_en'];
                $educations->organization_ar=$data['organization_ar'];
                $educations->organization_en=$data['organization_en'];
//                $educations->therapist_id=$data['therapist_id'];
                $educations->start_date=date('Y-m-d',strtotime($data['start_date']));
                $educations->end_date=date('Y-m-d',strtotime($data['end_date']));
                $educations->updated_at=date("Y-m-d H:i:s");
                if($educations->save()){
//                    save_all_trans($data,$id,'educations',['name'=>'names','organization'=>'organizations']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.educations'));
                    return Redirect::to('admin/educations/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Education  $education
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $educations=Education::find($id);
        if(!empty($educations)){
            $educations->save();
            if($educations->delete()){

            }
        }
    }
}
