<?php

namespace App\Http\Controllers\Admin;

use App\Experience;
use App\WebsiteLanguages;
use App\Therapist;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AdminExperienceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $search=$request->input('search');
        if($search){
            $experiences=Experience::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $experiences=Experience::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.experiences.view',compact('experiences'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $therapists = Therapist::pluck('title','id');
        return view('admin.experiences.add',compact('therapists'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'name_en'=>'required',
                'organization_en'=>'required',
//                'therapist_id'=>'required',
                'start_date'=>'required',
                'end_date'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $experiences=new Experience();
            $experiences->name_ar=$data['name_ar'];
            $experiences->name_en=$data['name_en'];
            $experiences->organization_ar=$data['organization_ar'];
            $experiences->organization_en=$data['organization_en'];
//            $experiences->therapist_id=$data['therapist_id'];
            $experiences->start_date=date('Y-m-d',strtotime($data['start_date']));
            $experiences->end_date=date('Y-m-d',strtotime($data['end_date']));
            $experiences->created_at=date("Y-m-d H:i:s");
            if($experiences->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('main.experiences'));
                return Redirect::to('admin/experiences/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Experience  $experience
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Experience  $experience
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $experience=Experience::find($id);
        $therapists = Therapist::pluck('title','id');
//        $languages = get_language_trans($id,'experiences');
        if(!empty($experience)){
            return view('admin.experiences.edit',compact('experience','therapists'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Experience  $experience
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $experiences= Experience::find($id);
        if(!empty($experiences)){
            $validator = Validator::make($request->all(),
                array(
                    'name_en'=>'required',
                    'organization_en'=>'required',
//                    'therapist_id'=>'required',
                    'start_date'=>'required',
                    'end_date'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $experiences->name_ar=$data['name_ar'];
                $experiences->name_en=$data['name_en'];
                $experiences->organization_ar=$data['organization_ar'];
                $experiences->organization_en=$data['organization_en'];
//                $experiences->therapist_id=$data['therapist_id'];
                $experiences->start_date=date('Y-m-d',strtotime($data['start_date']));
                $experiences->end_date=date('Y-m-d',strtotime($data['end_date']));
                $experiences->updated_at=date("Y-m-d H:i:s");
                if($experiences->save()){
//                    save_all_trans($data,$id,'experiences',['name'=>'names','organization'=>'organizations']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.experiences'));
                    return Redirect::to('admin/experiences/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Experience  $experience
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $experiences=Experience::find($id);
        if(!empty($experiences)){
            $experiences->save();
            if($experiences->delete()){

            }
        }
    }
}
