<?php

namespace App\Http\Controllers\Admin;

use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Languages;
use Yajra\DataTables\Facades\DataTables;
class AdminLanguageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

       /* $search=$request->input('search');
        if($search){
            $languages=Languages::where('title_ar','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $languages=Languages::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.languages.view',compact('languages'));*/


        if ($request->ajax()) {

            $languages=Languages::orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $languages = $languages->where('active', 1);
                       break;
                   case 'unactive':
                       $languages = $languages->where('active', 0);
                       break;
               }
           }

           return DataTables::of($languages)
               ->addIndexColumn()



               ->addColumn('active', function ($languages) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $languages->id . '" type="checkbox" ' . (!PerUser('languages_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('languages_active') ? 'changeStatues' : '') . '"  ' . (($languages->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $languages->id . '"><label for="checkbox-' . $languages->id . '"></label></div>';
               })
               ->addColumn('action', function ($languages) {
                   return '
           ' . (PerUser('languages_edit') ? '<a class="btn btn-success" href="' . URL('admin/languages/' . $languages->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('languages_delete') ? '<a class="btn btn-danger" href="' . URL('languages_delete/'. $languages->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.languages.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = Languages::all();
        return view('admin.languages.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'title_ar'=>'required',
                'title_en'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active=(isset($data['active']))?1:0;
            $languages=new Languages();
            $languages->active=$active;
            $languages->created_at=date("Y-m-d H:i:s");
            if($languages->save()){
//                save_all_trans($data,$languages->id,'languages',['name'=>'names']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.languages'));
                return Redirect::to('admin/languages/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\WebsiteLanguages  $language
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\WebsiteLanguages  $language
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $language=Languages::find($id);
        if(!empty($language)){
            return view('admin.languages.edit',compact('language'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\WebsiteLanguages  $language
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data=$request->input();
        $languages= Languages::find($id);
        if(!empty($languages)){
            $validator = Validator::make($request->all(),
                array(
                    'title_ar'=>'required',
                    'title_en'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $active=(isset($data['active']))?1:0;
                $languages->title_ar=$data['title_ar'];
                $languages->title_en=$data['title_en'];
                $languages->active=$active;
                $languages->updated_at=date("Y-m-d H:i:s");
                if($languages->save()){
                    Session::flash('success', Lang::get('main.update').Lang::get('main.languages'));
                    return Redirect::to('admin/languages/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\WebsiteLanguages  $language
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $languages=Languages::find($id);
        if(!empty($languages)){
//            $languages->deleted_by=Auth::user()->id;
            $languages->save();
            if($languages->delete()){
                Session::flash('success', Lang::get('main.languages') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/languages');
            }
        }
    }

    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $language=Languages::find($id);
            if ($active == 0) {
                $language->active = 0;
            } elseif ($active == 1) {
                $language->active = 1;
            }
            $language->save();
        }else{
            return redirect(404);
        }
    }
}
