<?php

namespace App\Http\Controllers\Admin;

use App\MainFocus;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminMainFocusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      /*  $search=$request->input('search');
        $parents = MainFocus::orderBy('sort','ASC')->pluck('title_ar','id');
        if($search){
            $main_focus=MainFocus::where('title_ar','LIKE',"%$search%")->orderBy('sort','ASC')->paginate(100);
        }else{
            $main_focus=MainFocus::orderBy('sort','ASC')->paginate(100);
        }
        return view('admin.main_focus.view',compact('main_focus','parents'));*/

        if ($request->ajax()) {

            $main_focus=MainFocus::orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $main_focus = $main_focus->where('active', 1);
                       break;
                   case 'unactive':
                       $main_focus = $main_focus->where('active', 0);
                       break;
               }
           }

           return DataTables::of($main_focus)
               ->addIndexColumn()



               ->addColumn('active', function ($main_focus) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $main_focus->id . '" type="checkbox" ' . (!PerUser('main_focus_view') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('main_focus_view') ? 'changeStatues' : '') . '"  ' . (($main_focus->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $main_focus->id . '"><label for="checkbox-' . $main_focus->id . '"></label></div>';
               })
               ->addColumn('action', function ($main_focus) {
                   return '
           ' . (PerUser('main_focus_edit') ? '<a class="btn btn-success" href="' . URL('admin/main_focus/' . $main_focus->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('main_focus_delete') ? '<a class="btn btn-danger" href="' . URL('main_focus_delete/'. $main_focus->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.main_focus.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $parents = MainFocus::orderBy('sort','ASC')->pluck('title_ar','id');
//        $languages = WebsiteLanguages::orderBy('default','desc')->get();
        return view('admin.main_focus.add',compact('parents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'title_ar'=>'required',
                'title_en'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active=(isset($data['active']))?1:0;
            $main_focus=new MainFocus();
            $main_focus->title_ar=$data['title_ar'];
            $main_focus->title_en=$data['title_en'];
            $main_focus->parent_id=$data['parent_id'];
            $main_focus->active=$active;
            $main_focus->sort=$request->sort;
            $main_focus->created_at=date("Y-m-d H:i:s");
            if($main_focus->save()){
//                save_all_trans($data,$main_focus->id,'main_focus',['title'=>'titles']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.main_focus'));
                return Redirect::to('admin/main_focus/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\MainFocus  $specialist
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\MainFocus  $specialist
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $specialist=MainFocus::find($id);
        $parents = MainFocus::orderBy('sort','ASC')->pluck('title_ar','id');
//        $languages = get_language_trans($id,'main_focus');
        if(!empty($specialist)){
            return view('admin.main_focus.edit',compact('specialist','parents'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\MainFocus  $specialist
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data=$request->input();
        $main_focus= MainFocus::find($id);
        if(!empty($main_focus)){
            $validator = Validator::make($request->all(),
                array(
                    'title_ar'=>'required',
                    'title_en'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $active=(isset($data['active']))?1:0;
                $main_focus->title_ar=$data['title_ar'];
                $main_focus->title_en=$data['title_en'];
                $main_focus->parent_id=$data['parent_id'];
                $main_focus->active=$active;
                $main_focus->sort=$request->sort;
                $main_focus->updated_at=date("Y-m-d H:i:s");
                if($main_focus->save()){
//                    save_all_trans($data,$id,'main_focus',['title'=>'titles']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.main_focus'));
                    return Redirect::to('admin/main_focus/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\MainFocus  $specialist
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $main_focus=MainFocus::find($id);
        if(!empty($main_focus)){
//            $main_focus->deleted_by=Auth::user()->id;
            $main_focus->save();
            if($main_focus->delete()){
                Session::flash('success', Lang::get('main.main_focus') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/main_focus');
            }
        }
    }
    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $main_focus=MainFocus::find($id);
            if ($active == 0) {
                $main_focus->active = 0;
            } elseif ($active == 1) {
                $main_focus->active = 1;
            }
            $main_focus->save();
        }else{
            return redirect(404);
        }
    }
}
