<?php

namespace App\Http\Controllers\Admin;

use App\Partners;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminPartnerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
     /*   $search=$request->input('search');
        if($search){
            $partners=Partners::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $partners=Partners::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.partners.view',compact('partners'));*/

        if ($request->ajax()) {

            $partners=Partners::orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $partners = $partners->where('active', 1);
                       break;
                   case 'unactive':
                       $partners = $partners->where('active', 0);
                       break;
               }
           }

           return DataTables::of($partners)
               ->addIndexColumn()


               ->editColumn('picture', function ($partners) {
                   return '<img style="height: 100px;width: 100px;" src="' . asset('avatars/partners/'.$partners->picture) . '"   alt="">';
               })

               ->addColumn('active', function ($partners) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $partners->id . '" type="checkbox" ' . (!PerUser('partners_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('partners_active') ? 'changeStatues' : '') . '"  ' . (($partners->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $partners->id . '"><label for="checkbox-' . $partners->id . '"></label></div>';
               })
               ->addColumn('action', function ($partners) {
                   return '
           ' . (PerUser('partners_edit') ? '<a class="btn btn-success" href="' . URL('admin/partners/' . $partners->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('partners_delete') ? '<a class="btn btn-danger" href="' . URL('partners_delete/'. $partners->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action', 'picture'])
               ->make(true);
       }
       return view('admin.partners.view');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default','desc')->get();
        return view('admin.partners.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'title'=>'required',
                'link'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active=(isset($data['active']))?1:0;
            $partners=new Partners();
            $partners->title=$data['title'];
            $partners->link=$data['link'];
            if($request->hasFile('picture')){
                $validator = Validator::make($request->all(),array(
                    'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                }else{
                    $file=$request->file('picture');
                    $image=FileImage($file,'avatars/partners','picture');
                    $partners->picture=$image['img'];
                }
            }
            $partners->active=$active;
            $partners->created_at=date("Y-m-d H:i:s");
            if($partners->save()){
//                save_all_trans($data,$partners->id,'partners',['title'=>'titles']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.partners'));
                return Redirect::to('admin/partners/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Partners  $partner
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Partners  $partner
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id,'partners');
        $partner=Partners::find($id);
        if(!empty($partner)){
            return view('admin.partners.edit',compact('partner','languages'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Partners  $partner
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $partners= Partners::find($id);
        if(!empty($partners)){
            $validator = Validator::make($request->all(),
                array(
                    'title'=>'required',
                    'link'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                if($request->hasFile('picture')){
                    $validator = Validator::make($request->all(),array(
                        'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }else{
                        if(file_exists(public_path().$partners->img_dir.$partners->img)&&!empty($partners->img_dir)){
                            unlink(public_path().$partners->img_dir.$partners->img);
                        }
                        $file=$request->file('picture');
                        $image=FileImage($file,'avatars/partners');
                        $partners->picture=$image['img'];
                    }
                }
                $active=(isset($data['active']))?1:0;
                $partners->title=$data['title'];
                $partners->link=$data['link'];
                $partners->active=$active;
                $partners->updated_at=date("Y-m-d H:i:s");
                if($partners->save()){
//                    save_all_trans($data,$id,'partners',['title'=>'titles']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.partners'));
                    return Redirect::to('admin/partners/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Partners  $partner
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $partners=Partners::find($id);
        if(!empty($partners)){
//            $partners->deleted_by=Auth::user()->id;
            $partners->save();
            if($partners->delete()){
                Session::flash('success', Lang::get('main.partners') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/partners');
            }
        }
    }

    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $partner=Partners::find($id);
            if ($active == 0) {
                $partner->active = 0;
            } elseif ($active == 1) {
                $partner->active = 1;
            }
            $partner->save();
        }else{
            return redirect(404);
        }
    }
}
