<?php

namespace App\Http\Controllers\Admin;

use App\PaymentMethod;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminPaymentMethodController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /* $search=$request->input('search');
        if($search){
            $payment_methods=PaymentMethod::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $payment_methods=PaymentMethod::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.payment_methods.view',compact('payment_methods'));*/


        if ($request->ajax()) {

            $payment_methods = PaymentMethod::orderBy('id', 'DESC');


            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $payment_methods = $payment_methods->where('active', 1);
                        break;
                    case 'unactive':
                        $payment_methods = $payment_methods->where('active', 0);
                        break;
                }
            }

            return DataTables::of($payment_methods)
                ->addIndexColumn()

                ->editColumn('picture', function ($payment_method) {
                    return '<img style="height: 100px;width: 100px;" src="' . asset('payment_methods/' . $payment_method->picture) . '"   alt="">';
                })
                ->addColumn('active', function ($payment_method) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $payment_method->id . '" type="checkbox" ' . (!PerUser('payment_methods_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('payment_methods_active') ? 'changeStatues' : '') . '"  ' . (($payment_method->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $payment_method->id . '"><label for="checkbox-' . $payment_method->id . '"></label></div>';
                })
                ->addColumn('action', function ($payment_method) {
                    return '
                    ' . (PerUser('payment_methods_edit') ? '<a class="btn btn-success" href="' . URL('admin/payment_methods/' . $payment_method->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
                    ' . (PerUser('payment_methods_delete') ? '<a class="btn btn-danger" href="' . URL('payment_methods_delete/'. $payment_method->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                    ';
                })

                ->rawColumns(['active', 'action', 'picture'])
                ->make(true);
        }
        return view('admin.payment_methods.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default', 'desc')->get();
        return view('admin.payment_methods.add', compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'title' => 'required',
                'description' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $payment_methods = new PaymentMethod();
            $payment_methods->title = $data['title'];
            $payment_methods->description = $data['description'];
            if ($request->hasFile('picture')) {
                $validator = Validator::make($request->all(), array(
                    'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                } else {
                    $file = $request->file('picture');
                    $image = FileImage($file, 'payment_methods', 'picture');
                    $payment_methods->picture = $image['img'];
                }
            }
            $payment_methods->active = $active;
            $payment_methods->created_at = date("Y-m-d H:i:s");
            if ($payment_methods->save()) {
                //                save_all_trans($data,$payment_methods->id,'payment_methods',['title'=>'titles','description'=>'descriptions']);
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.payment_methods'));
                return Redirect::to('admin/payment_methods/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\PaymentMethod  $payment_method
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\PaymentMethod  $payment_method
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id, 'payment_methods');
        $payment_method = PaymentMethod::find($id);
        if (!empty($payment_method)) {
            return view('admin.payment_methods.edit', compact('payment_method', 'languages'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\PaymentMethod  $payment_method
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $payment_methods = PaymentMethod::find($id);
        if (!empty($payment_methods)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'title' => 'required',
                    'description' => 'required',
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                if ($request->hasFile('picture')) {
                    $validator = Validator::make($request->all(), array(
                        'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    } else {
                        if (file_exists(public_path() . $payment_methods->img_dir . $payment_methods->img) && !empty($payment_methods->img_dir)) {
                            unlink(public_path() . $payment_methods->img_dir . $payment_methods->img);
                        }
                        $file = $request->file('picture');
                        $image = FileImage($file, 'payment_methods');
                        $payment_methods->picture = $image['img'];
                    }
                }
                $active = (isset($data['active'])) ? 1 : 0;
                $payment_methods->title = $data['title'];
                $payment_methods->description = $data['description'];
                $payment_methods->active = $active;
                $payment_methods->updated_at = date("Y-m-d H:i:s");
                if ($payment_methods->save()) {
                    //                    save_all_trans($data,$id,'payment_methods',['title'=>'titles','description'=>'descriptions']);
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.payment_methods'));
                    return Redirect::to('admin/payment_methods/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\PaymentMethod  $payment_method
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $payment_methods = PaymentMethod::find($id);
        if (!empty($payment_methods)) {
            //            $payment_methods->deleted_by=Auth::user()->id;
            $payment_methods->save();
            if ($payment_methods->delete()) {
                Session::flash('success', Lang::get('main.payment_methods') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/payment_methods');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $payment_method = PaymentMethod::find($id);
            if ($active == 0) {
                $payment_method->active = 0;
            } elseif ($active == 1) {
                $payment_method->active = 1;
            }
            $payment_method->save();
        } else {
            return redirect(404);
        }
    }
}
