<?php

namespace App\Http\Controllers\Admin;

use App\Certificates;
use App\Countries;
use App\Education;
use App\Experience;
use App\Exports\PaymentsExport;
use App\Specialties;
use App\Therapist;
use App\Therapists_languages;
use App\TherapistsInvoices;
use App\TherapistsSpecialties;
use App\Visitor;
use App\WebsiteLanguages;
use App\Languages;
use App\Profiles;
use App\User;
use App\Payments;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;
use App\TherapistsPictures;
use App\TherapistsRequests;
use App\Therapists_specialties;

class AdminPaymentsRequstsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
     /*   $payments=Payments::with('therapist')->with('user')->with('Sessions')->get();
        dd($payments);*/
    if ($request->ajax()) {


        $payments=Payments::with('therapist')->with('sessions')->with('user');
        $website_percentage=getAppSetting('website_percentage');
        $minimum_price_30=getAppSetting('minimum_price_30');
        $minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
        $minimum_price_60=getAppSetting('minimum_price_60');
        $minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');

            return DataTables::of($payments)
                ->addIndexColumn() 
                ->addColumn('therapist_amount', function($payment)use($website_percentage,$minimum_price_30,$minimum_price_30_dolar,$minimum_price_60,$minimum_price_60_dolar){
                    if(!isset($payment->sessions->type)){
                        return 0;
                    }
                    if(in_array($payment->sessions->type,[30,3,10])){
                        if($payment->currancy=='EGP'){
                            $minimum_price=$minimum_price_30;
                        }else{
                            $minimum_price=$minimum_price_30_dolar;
                        }
                    }
                    if(in_array($payment->sessions->type,[60,6,15])){
                        if($payment->currancy=='EGP'){
                            $minimum_price=$minimum_price_60;
                        }else{
                            $minimum_price=$minimum_price_60_dolar;
                        }
                    }

                    if($payment->discount_amount > 0)
                    {
                        $therDiscount = ($payment->discount_amount/2);
                        return calculateTherapistAmount(($payment->currancy=='EGP'?$payment->price:$payment->price_dolar),$website_percentage,$minimum_price) + $therDiscount;
                    }
                    else
                    {
                        return calculateTherapistAmount(($payment->currancy=='EGP'?$payment->price:$payment->price_dolar),$website_percentage,$minimum_price);
                    }
                    
                })
                ->addColumn('therapist',function($payments){
                    $session = \App\Sessions::find($payments->session_id);
                    if($session)
                    {
                        $therapist = \App\Therapist::find($session->therapist_id);
                        if($therapist)
                        {
                            return $therapist->name_e;
                        }
                        
                    }
                    
                })
                ->addColumn('action', function ($payments) {
                    $html='';
                    if ($payments->status !='approved') {
                        $html.= '
                        ' . (PerUser('therapistsrequests_disapprove') ? '<a target="_blank" id="disapprove" class="btn btn-primary" href="' . URL('viewcontent/' . $payments->id ) . '"><i class="fa fa-eye"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '

                                    ';
                    }else{
                        $html.= '
                        ' . (PerUser('therapistsrequests_disapprove') ? '<button disabled id="disapprove" class="btn btn-danger" ><i class="fa fa-eye"></i>' ./*Lang::get('main.edit').*/ '</button>' : '') . '

                                    ';
                    }
                    if($payments->status=='pending'){
                        $html.='<button data-id="'.$payments->id.'" class="btn btn-success makeApproved" title="'.__('main.Approve').'" ><i class="fa fa-check-circle"></i></button><button data-id="'.$payments->id.'" class="btn btn-danger makeCanceled" title="'.__('main.Cancel').'" ><i class="fa fa-times-circle"></i></button>';
                    }

                    return $html;

                })

                ->rawColumns(['action'])
                ->make(true);
       }

        return view('admin.payments.view');
    }


    public function edit($id)
    {

        $payment= Payments::where('id', $id)->first();
        $paymentcontent=$payment->html_body_content;
         return view('admin.payments.viewcontent')->with('paymentcontent',$paymentcontent);
    }


    public function disapprove($id)
    {

       $payment= Payments::where('id', $id)->first();
       $paymentcontent=$payment->html_body_content;

        return view('admin.payments.viewcontent')->with('paymentcontent',$paymentcontent);
    }
    public function export(){
        $fileName = 'payments_'.time();
        return Excel::download(new PaymentsExport, $fileName.'.xlsx');
        $payments = Payments::with('sessions','sessions.therapist','sessions.therapist.user','user')->get();

        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Therapist', 'Patients', 'Session Date Time', 'Session_Real_OR_Test','Status', 'Price','Therapist Amount','Payment Method', 'Created at');

        $callback = function() use($payments, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
            $website_percentage=getAppSetting('website_percentage');
            $minimum_price_30=getAppSetting('minimum_price_30');
            $minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
            $minimum_price_60=getAppSetting('minimum_price_60');
            $minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
            foreach ($payments as $payment) {
                $therapistAmount=0;
                if(!isset($payment->sessions->type)){
                    $therapistAmount=0;
                }else{
                    if(in_array($payment->sessions->type,[30,3,10])){
                        if($payment->currancy=='EGP'){
                            $minimum_price=$minimum_price_30;
                        }else{
                            $minimum_price=$minimum_price_30_dolar;
                        }
                    }
                    if(in_array($payment->sessions->type,[60,6,15])){
                        if($payment->currancy=='EGP'){
                            $minimum_price=$minimum_price_60;
                        }else{
                            $minimum_price=$minimum_price_60_dolar;
                        }
                    }
                    $therapistAmount= calculateTherapistAmount(($payment->currancy=='EGP'?$payment->price:$payment->price_dolar),$website_percentage,$minimum_price);
                }

                $row['Therapist']  = (isset($payment->sessions->therapist->user))?$payment->sessions->therapist->user->name:'';
                $row['Patients']    =($payment->user)?$payment->user->name:'';
                $row['Session Date Time']    = (isset($payment->sessions->start_time))?$payment->sessions->start_time:'';

                $row['Session_Real_OR_Test']    = (isset($payment->sessions->topic) && $payment->sessions->topic == 'test')?'Test':'Real';
                $row['Status']  = $payment->status;
                $row['Price']  = $payment->price;
                $row['Therapist Amount']  = $payment->price;
                $row['Payment Method']  = $payment->payment_method;
                $row['Created at']  = $payment->created_at;

                fputcsv($file, array($row['Therapist'], $row['Patients'], $row['Date'], $row['Status'], $row['Price'], $row['Price'], $row['Payment Method']));
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }
    public function makeCanceled($id){
        $payment=Payments::find($id);
        if($payment->status=='pending'){
            $payment->status='canceled';
            $payment->canceled_date=date('Y-m-d H:i:s');
            $payment->save();
            $session=$payment->sessions;
            $session->visitor_id=NULL;
            $session->status=1;
            $session->session_status='available';
            $session->cancelled_reason='Payment canceled #'.$payment->id;
            $session->cancelled_date=date('Y-m-d H:i:s');
            $session->save();
            TherapistsInvoices::where('session_id',$session->id)->where('therapist_id',$payment->therapist_id)->delete();
            sendCanceledEmail([$session],'therapist');
            return response()->json(['success'=>true]);
        }
    }
    public function makeApproved($id){
        $payment=Payments::find($id);
        if($payment->status=='pending'){
            $payment->status='approved';
            $payment->approved_date=date('Y-m-d H:i:s');
            $payment->save();
            return response()->json(['success'=>true]);
        }
    }
}
