<?php

namespace App\Http\Controllers\Admin;

use App\Properties;
use App\WebsiteLanguages;
use App\Profiles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminPropertyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /* $search=$request->input('search');
        if($search){
            $properties=Properties::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $properties=Properties::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.properties.view',compact('properties'));*/

        if ($request->ajax()) {

            $properties = Properties::orderBy('id', 'DESC');


            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $properties = $properties->where('active', 1);
                        break;
                    case 'unactive':
                        $properties = $properties->where('active', 0);
                        break;
                }
            }

            return DataTables::of($properties)
                ->addIndexColumn()


                ->editColumn('picture', function ($propertie) {
                    return '<img style="height: 100px;width: 100px;" src="' . asset('avatars/properties/' . $propertie->picture) . '"   alt="">';
                })

                ->addColumn('active', function ($propertie) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $propertie->id . '" type="checkbox" ' . (!PerUser('properties_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('properties_active') ? 'changeStatues' : '') . '"  ' . (($propertie->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $propertie->id . '"><label for="checkbox-' . $propertie->id . '"></label></div>';
                })
                ->addColumn('action', function ($propertie) {
                    return '
            ' . (PerUser('properties_edit') ? '<a class="btn btn-success" href="' . URL('admin/properties/' . $propertie->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
            ' . (PerUser('properties_delete') ? '<a class="btn btn-danger" href="' . URL('properties_delete/'. $propertie->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
            ';
                })

                ->rawColumns(['active', 'action', 'picture'])
                ->make(true);
        }
        return view('admin.properties.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default', 'desc')->get();
        return view('admin.properties.add', compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $properties = new Properties();
            $properties->title_ar = $data['title_ar'];
            $properties->title_en = $data['title_en'];
            $properties->description_ar = $data['description_ar'];
            $properties->description_en = $data['description_en'];
            $properties->sort = $data['sort'];
            if ($request->hasFile('picture')) {
                $validator = Validator::make($request->all(), array(
                    'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                } else {
                    $file = $request->file('picture');
                    $destinationPath = public_path('avatars/properties');
                    $fileName = $file->getClientOriginalName();
                    $file->move($destinationPath, $fileName);
                    $properties->picture = $fileName;
                }
            }
            $properties->active = $active;
            $properties->created_at = date("Y-m-d H:i:s");
            if ($properties->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.properties'));
                return Redirect::to('admin/properties/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Properties  $property
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Properties  $property
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id, 'properties');
        $property = Properties::find($id);
        if (!empty($property)) {
            return view('admin.properties.edit', compact('property', 'languages'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Properties  $property
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        global  $updatedFileName;
        $data = $request->input();
        $properties = Properties::find($id);
        if (!empty($properties)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'title_ar' => 'required',
                    'title_en' => 'required',
                    'description_ar' => 'required',
                    'description_en' => 'required',
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                if ($request->hasFile('picture')) {
                    $validator = Validator::make($request->all(), array(
                        'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    } else {
                        if (file_exists(public_path() . '/avatars/properties/' . $properties->picture))
                            @unlink(public_path() . '/avatars/properties/' . $properties->picture);

                        $file = $request->file('picture');
                        $destinationPath = public_path('avatars/properties');
                        $updatedFileName = $file->getClientOriginalName();
                        $file->move($destinationPath, $updatedFileName);
                        $properties->picture = $updatedFileName;
                    }
                }
                $active = (isset($data['active'])) ? 1 : 0;
                $properties->title_ar = $data['title_ar'];
                $properties->title_en = $data['title_en'];
                $properties->description_ar = $data['description_ar'];
                $properties->description_en = $data['description_en'];
                $properties->sort = $data['sort'];
                $properties->active = $active;
                $properties->updated_at = date("Y-m-d H:i:s");

                if ($properties->save()) {
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.properties'));
                    return Redirect::to('admin/properties/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Properties  $property
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $properties = Properties::find($id);
        if (!empty($properties)) {
            //            $properties->deleted_by=Auth::user()->id;
            $properties->save();
            if ($properties->delete()) {
                Session::flash('success', Lang::get('main.properties') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/properties');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $property = Properties::find($id);
            if ($active == 0) {
                $property->active = 0;
            } elseif ($active == 1) {
                $property->active = 1;
            }
            $property->save();
        } else {
            return redirect(404);
        }
    }
}
