<?php

namespace App\Http\Controllers\Admin;

use App\Rating;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminRatingController extends Controller
{
   
    public function index(Request $request)
    {
     
        if ($request->ajax()) {

            $rating=Rating::orderBy('id','desc');


           

           return DataTables::of($rating)
               ->addIndexColumn()

               

               ->addColumn('active', function ($rating) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $rating->id . '" type="checkbox" ' . (!PerUser('rating_view') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('rating_view') ? 'changeStatues' : '') . '"  ' . (($rating->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $rating->id . '"><label for="checkbox-' . $rating->id . '"></label></div>';
               })
                ->addColumn('action', function ($rating) {
                    return '
                    ' . (PerUser('rating_delete') ? '<a class="btn btn-danger delete_this" data-id="'.$rating->id.'" href="' . URL('rating_delete/'. $rating->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                    ';
                })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.rating.view');
    }

  
    public function create()
    {
        return view('admin.rating.add');
    }


    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'image' => 'required|mimes:jpg,jpeg,bmp,png'
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $rating=new rating();
            $file = $request->file('image');
            $image = FileImage($file, 'Rating/', 'image');
            $rating->image = $image['img'];
            $rating->created_at=date("Y-m-d H:i:s");
            if($rating->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('home.rating'));
                return Redirect::to('admin/rating/create');
            }
        }
    }



    public function edit($id)
    {
        $rating=Rating::find($id);
        if(!empty($rating)){
            return view('admin.rating.edit',compact('rating'));
        }else{
            return abort(404);
        }
    }


    public function update(Request $request, $id)
    {

        $data = $request->input();
        $rating = Rating::find($id);
            $validator = Validator::make(
                $request->all(),
                array(
                    'image' => 'required'
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                if ($request->hasFile('image')) {
                    if (file_exists(public_path() . $rating->img_dir . $rating->img) && !empty($rating->img_dir)) {
                        unlink(public_path() . $rating->img_dir . $rating->img);
                    }
                    $file = $request->file('image');
                    $image = FileImage($file, 'Rating/');
                    $rating->image = $image['img'];
                }
                $rating->updated_at = date("Y-m-d H:i:s");
                if ($rating->save()) {
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.rating'));
                    return Redirect::to('admin/rating/' . $id . '/edit');
                }
            }



     
    }


    public function destroy($id)
    {
        //
        $rating=Rating::find($id);
        if(!empty($rating)){
            $rating->save();
            if($rating->delete()){
                Session::flash('success', Lang::get('main.rating') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/rating');
            }
        }
    }
    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $rating=rating::find($id);
            if ($active == 0) {
                $rating->active = 0;
            } elseif ($active == 1) {
                $rating->active = 1;
            }
            $rating->save();
        }else{
            return redirect(404);
        }
    }
}
