<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Recommendation;
use App\RecommendationType;
use Yajra\DataTables\Facades\DataTables;
class AdminRecommendationController extends Controller
{
    public function index(Request $request)
    {
  /*     $allAnswers = RecommendationType::with('recommendations')->get();
        return view('admin.recommendations.view',compact('allAnswers'));
*/
        if ($request->ajax()) {

            $allAnswers=RecommendationType::with('recommendations');



           return DataTables::of($allAnswers)
               ->addIndexColumn()



               ->addColumn('active', function ($allAnswers) {
               })


               ->addColumn('action', function ($allAnswers) {
                return '
        ' . (PerUser('answer_view') ? '<a class="btn btn-success" href="' . URL('admin/answers/' . $allAnswers->id ) . '"><i class="fa fa-eye"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
        ' . (PerUser('answer_delete') ? '<a class="btn btn-danger" href="' . URL('answer_delete/'. $allAnswers->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
        ';
            })
               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.recommendations.view');



    }

    public function show($id)
    {
        $recommendAnswers = RecommendationType::findOrFail($id);
        return view('admin.recommendations.display-answers',compact('recommendAnswers'));
    }

    public function destroy($id)
    {
        $answer = Recommendation::findOrFail($id);
        $answer->delete();

        return response()->json('Answer Deleted Successfully');
    }
}
