<?php

namespace App\Http\Controllers\Admin;

use App\Scale;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminScalesController extends Controller
{
   
    public function index(Request $request)
    {
     
        if ($request->ajax()) {

            $scales=Scale::orderBy('id','desc');


           

           return DataTables::of($scales)
               ->addIndexColumn()



               ->addColumn('active', function ($scales) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $scales->id . '" type="checkbox" ' . (!PerUser('scales_view') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('scales_view') ? 'changeStatues' : '') . '"  ' . (($scales->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $scales->id . '"><label for="checkbox-' . $scales->id . '"></label></div>';
               })
               ->addColumn('action', function ($scales) {
                   return '
           ' . (PerUser('scales_edit') ? '<a class="btn btn-success" href="' . URL('admin/scales/' . $scales->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.scales.view');
    }

  
    public function create()
    {
        $parents = Scale::pluck('name_ar','id');
        return view('admin.scales.add',compact('parents'));
    }


    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'name_en'=>'required',
                'description_en'=>'required',
                'nominations_en'=>'required',
                'duration_en'=>'required',
                'instructions_en'=>'required',
                'note_en'=>'required',
                'name_ar'=>'required',
                'description_ar'=>'required',
                'nominations_ar'=>'required',
                'duration_ar'=>'required',
                'instructions_ar'=>'required',
                'note_ar'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $scales=new Scale();
            $scales->name_en=$data['name_en'];
            $scales->description_en=$data['description_en'];
            $scales->nominations_en=$data['nominations_en'];
            $scales->duration_en=$data['duration_en'];
            $scales->instructions_en=$data['instructions_en'];
            $scales->note_en=$data['note_en'];
            $scales->name_ar=$data['name_ar'];
            $scales->description_ar=$data['description_ar'];
            $scales->nominations_ar=$data['nominations_ar'];
            $scales->duration_ar=$data['duration_ar'];
            $scales->instructions_ar=$data['instructions_ar'];
            $scales->note_ar=$data['note_ar'];
            $scales->is_free='yes';
            $scales->type='with_choices';
            $scales->active=1;
            $scales->created_at=date("Y-m-d H:i:s");
            if($scales->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('home.psychological-test'));
                return Redirect::to('admin/scales/create');
            }
        }
    }



    public function edit($id)
    {
        $scale=Scale::find($id);
        if(!empty($scale)){
            return view('admin.scales.edit',compact('scale'));
        }else{
            return abort(404);
        }
    }


    public function update(Request $request, $id)
    {

        $data=$request->input();
        $scales= Scale::find($id);
        $validator = Validator::make($request->all(),
            array(
                'name_en'=>'required',
                'description_en'=>'required',
                'nominations_en'=>'required',
                'duration_en'=>'required',
                'instructions_en'=>'required',
                'note_en'=>'required',
                'name_ar'=>'required',
                'description_ar'=>'required',
                'nominations_ar'=>'required',
                'duration_ar'=>'required',
                'instructions_ar'=>'required',
                'note_ar'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $scales->name_en=$data['name_en'];
            $scales->description_en=$data['description_en'];
            $scales->nominations_en=$data['nominations_en'];
            $scales->duration_en=$data['duration_en'];
            $scales->instructions_en=$data['instructions_en'];
            $scales->note_en=$data['note_en'];
            $scales->name_ar=$data['name_ar'];
            $scales->description_ar=$data['description_ar'];
            $scales->nominations_ar=$data['nominations_ar'];
            $scales->duration_ar=$data['duration_ar'];
            $scales->instructions_ar=$data['instructions_ar'];
            $scales->note_ar=$data['note_ar'];
            $scales->is_free='yes';
            $scales->type='with_choices';
            $scales->active=1;
            $scales->created_at=date("Y-m-d H:i:s");
            if($scales->save()){
                Session::flash('success', Lang::get('main.update').Lang::get('home.psychological-test'));
                return Redirect::to('admin/scales/'.$id.'/edit');
            }
        }


     
    }


    public function destroy($id)
    {
        //
        $scales=Scale::find($id);
        if(!empty($scales)){
            $scales->save();
            if($scales->delete()){
                Session::flash('success', Lang::get('main.scales') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/scales');
            }
        }
    }
    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $scales=Scale::find($id);
            if ($active == 0) {
                $scales->active = 0;
            } elseif ($active == 1) {
                $scales->active = 1;
            }
            $scales->save();
        }else{
            return redirect(404);
        }
    }
}
