<?php

namespace App\Http\Controllers\Admin;

use App\Scale;
use App\ScaleQuestion;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminScalesQuestionsController extends Controller
{
   
    public function index(Request $request)
    {
     
        if ($request->ajax()) {

            $scales=ScaleQuestion::orderBy('id','desc');


           

           return DataTables::of($scales)
               ->addIndexColumn()

               ->editColumn('scales_id',function($scales){
                    $scale = Scale::find($scales->scales_id);
                    return $scale->name_ar;
                })

               ->addColumn('active', function ($scales) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $scales->id . '" type="checkbox" ' . (!PerUser('scalesQuestions_view') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('scalesQuestions_view') ? 'changeStatues' : '') . '"  ' . (($scales->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $scales->id . '"><label for="checkbox-' . $scales->id . '"></label></div>';
               })
               ->addColumn('action', function ($scales) {
                   return '
           ' . (PerUser('scales_edit') ? '<a class="btn btn-success" href="' . URL('admin/scalesQuestions/' . $scales->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.scalesQuestions.view');
    }

  
    public function create()
    {
        $scales = Scale::get();
        return view('admin.scalesQuestions.add',compact('scales'));
    }


    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'name_ar'=>'required',
                'name_en'=>'required',
                'scales_id'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $scales=new ScaleQuestion();
            $scales->name_en=$data['name_en'];
            $scales->name_ar=$data['name_ar'];
            $scales->scales_id=$data['scales_id'];
            $scales->created_at=date("Y-m-d H:i:s");
            if($scales->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('home.psychological-test'));
                return Redirect::to('admin/scalesQuestions/create');
            }
        }
    }



    public function edit($id)
    {
        $scales = Scale::get();
        $scale=ScaleQuestion::find($id);
        if(!empty($scale)){
            return view('admin.scalesQuestions.edit',compact('scale', 'scales'));
        }else{
            return abort(404);
        }
    }


    public function update(Request $request, $id)
    {

        $data=$request->input();
        $scales= ScaleQuestion::find($id);
        $validator = Validator::make($request->all(),
            array(
                'name_ar'=>'required',
                'name_en'=>'required',
                'scales_id'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $scales->name_en=$data['name_en'];
            $scales->name_ar=$data['name_ar'];
            $scales->scales_id=$data['scales_id'];
            $scales->created_at=date("Y-m-d H:i:s");
            if($scales->save()){
                Session::flash('success', Lang::get('main.update').Lang::get('home.psychological-test'));
                return Redirect::to('admin/scalesQuestions/'.$id.'/edit');
            }
        }


     
    }


    public function destroy($id)
    {
        //
        $scales=ScaleQuestion::find($id);
        if(!empty($scales)){
            $scales->save();
            if($scales->delete()){
                Session::flash('success', Lang::get('main.scales') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/scalesQuestions');
            }
        }
    }
    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $scales=Scale::find($id);
            if ($active == 0) {
                $scales->active = 0;
            } elseif ($active == 1) {
                $scales->active = 1;
            }
            $scales->save();
        }else{
            return redirect(404);
        }
    }
}
