<?php

namespace App\Http\Controllers\Admin;

use App\Service;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /* $search=$request->input('search');
        if($search){
            $services=Service::where('title_ar','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $services=Service::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.services.view',compact('services'));*/

        if ($request->ajax()) {

            $services = Service::orderBy('id', 'DESC');

            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $services = $services->where('active', 1);
                        break;
                    case 'unactive':
                        $services = $services->where('active', 0);
                        break;
                }
            }


            return DataTables::of($services)
                ->addIndexColumn()
                ->addColumn('active', function ($service) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $service->id . '" type="checkbox" ' . (!PerUser('services_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('profiles_active') ? 'changeStatues' : '') . '"  ' . (($service->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $service->id . '"><label for="checkbox-' . $service->id . '"></label></div>';
                })

                ->addColumn('action', function ($service) {
                    return '
                    ' . (PerUser('services_edit') ? '<a class="btn btn-success" href="' . URL('admin/services/' . $service->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
                    ' . (PerUser('services_delete') ? '<a class="btn btn-danger" href="' . URL('services_delete/'. $service->id). '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                    ';
                })

                ->rawColumns(['active', 'action'])
                ->make(true);
        }
        return view('admin.services.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $services = Service::get();
        return view('admin.services.add', compact('services'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'title_ar' => 'required',
                'title_en' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $services = new Service();
            $services->title_ar = $data['title_ar'];
            $services->title_en = $data['title_en'];
            $services->active = $active;
            $services->created_at = date("Y-m-d H:i:s");
            if ($services->save()) {
                //                save_all_trans($data,$services->id,'services',['title'=>'titles','description'=>'descriptions']);
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.services'));
                return Redirect::to('admin/services/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = Service::find($id);
        if (!empty($service)) {
            return view('admin.services.edit', compact('service'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $services = Service::find($id);
        if (!empty($services)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'title_ar' => 'required',
                    'title_en' => 'required',
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                $active = (isset($data['active'])) ? 1 : 0;
                $services->title_ar = $data['title_ar'];
                $services->title_en = $data['title_en'];
                $services->active = $active;
                $services->updated_at = date("Y-m-d H:i:s");
                if ($services->save()) {
                    //                    save_all_trans($data,$id,'services',['title'=>'titles','description'=>'descriptions']);
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.services'));
                    return Redirect::to('admin/services/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $services = Service::find($id);
        if (!empty($services)) {
            //            $services->deleted_by=Auth::user()->id;
            $services->save();
            if ($services->delete()) {
                Session::flash('success', Lang::get('main.services') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/services');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $service = Service::find($id);
            if ($active == 0) {
                $service->active = 0;
            } elseif ($active == 1) {
                $service->active = 1;
            }
            $service->save();
        } else {
            return redirect(404);
        }
    }
}
