<?php

namespace App\Http\Controllers\Admin;

use App\Payments;
use App\Sessions;
use App\SessionsTimesChanges;
use App\TherapistsInvoices;
use App\User;
use App\WebsiteLanguages;
use App\Therapist;
use App\Visitor;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Http\Controllers\ZoomController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use App\Coupons;
use App\CouponsUsed;

class AdminSessionController extends ZoomController
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /* $search=$request->input('search');
        if($search){
            $sessions=Sessions::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $sessions=Sessions::with('therapist','visitor.user')->orderBy('id','DESC')->paginate(100);
        }

       // dd($sessions);
        return view('admin.sessions.view',compact('sessions'));*/

        /* $sessions=Sessions::with('therapist','visitor.user')->orderBy('id','DESC')->get();
         dd($sessions);*/
        if ($request->ajax()) {

            $sessions = Sessions::select('sessions.id','sessions.therapist_id','therapistUser.name AS therapist_name','sessions.type','visitorUser.name AS visitor_name','sessions.session_status','sessions.start_time','sessions.rating')
                //->with('therapist','therapist.user','visitor','visitor.user');
            ->leftJoin('therapists','therapists.id','=','sessions.therapist_id')
            ->leftJoin('users AS therapistUser','therapistUser.id','=','therapists.user_id')
            ->leftJoin('visitors','visitors.id','=','sessions.visitor_id')
                ->leftJoin('users AS visitorUser','visitorUser.id','=','visitors.user_id')
            ;
            if($request->therapist_id){
                $sessions=$sessions->where('therapist_id',$request->therapist_id);
            }
            if($request->from_date&&$request->to_date){
                $sessions=$sessions->whereBetween('start_time',[$request->from_date,$request->to_date]);
            }
            if($request->session_id){
                $sessions->where('id',$request->session_id);
            }
            if($request->session_status){
                $sessions=$sessions->where(function($q)use ($request){
                    $array=['available','reserved','cancelled','requested','suggested','visitor_cancelled','closed'];
                    foreach ($array as $item){
                        if(in_array($item,$request->session_status)){
                            $q->orWhere('session_status',$item);
                        }
                    }
                    if(in_array('session_done',$request->session_status)){
                        $q->where(function($q1){
                            $q1->whereNotNull('visitor_start_date')->whereNotNull('therapist_start_date');
                        });
                    }
                    if(in_array('therapist_not_start',$request->session_status)){
                        $q->where(function($q1){
                            $q1->where('session_status','reserved')->whereNull('therapist_start_date');
                        });
                    }

                });

            }
            //$sessions=$sessions->take($request->length)->skip($request->start);
            return DataTables::of($sessions)
                ->addIndexColumn()
                ->editColumn('start_time',function($session){
                    $timezone=($session->therapist&&$session->therapist->user)?$session->therapist->user->timezone:'Africa/Cairo';
                    return convertDateTimezone($session->start_time,$timezone,'Y-m-d h:i a');
                })
                ->addColumn('session_status', function($row){
                    $class='bg-danger';
                    switch ($row->session_status){
                        case 'available':
                            $class='bg-info';
                            break;
                        case 'reserved':
                            $class='bg-warning';
                            break;
                        case 'cancelled':
                            $class='bg-danger';
                            break;
                        case 'requested':
                            $class='bg-danger';
                            break;
                        case 'suggested':
                            $class='bg-danger';
                            break;
                        case 'visitor_cancelled':
                            $class='bg-danger';
                            break;
                        case 'closed':
                            $class='bg-success';
                            break;
                    }
                    if ($row->session_status == 'closed' && $row->visitor_end_date != null && $row->therapist_end_date != null)
                    {
                        return '<span class="bg-success" style="padding:7px;"> '.trans('main.session_done').' </span>';
                    }elseif($row->session_status == 'reserved' && $row->visitor_start_date != null && $row->therapist_start_date == null){
                        return'<span class="bg-danger" style="padding:7px;">'.trans('main.therapist_not_start').'</span>';
                    }
                    else
                    {
                        return'<span class="'.$class.'" style="padding:7px;">'.trans('main.'.$row->session_status).'</span>';
                    }
                })


                ->addColumn('action', function ($sessions) {
                    return '
                   ' . (PerUser('sessions_edit') ? '<a class="btn btn-success" href="' . URL('admin/sessions/' . $sessions->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '

           ' . (PerUser('sessions_delete') ? '<a class="btn btn-danger" href="' . URL('sessions_delete/'. $sessions->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
                })

                ->rawColumns(['action','session_status'])
                ->make(true);
        }
        return view('admin.sessions.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $therapists = Therapist::pluck('title', 'id');
        $visitors = Visitor::join('users','users.id','=','visitors.user_id')->pluck('users.name', 'visitors.id');
        $languages = WebsiteLanguages::orderBy('default', 'desc')->get();
        return view('admin.sessions.add', compact('languages', 'visitors', 'therapists'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'therapist_id' => 'required',
                'visitor_id' => 'required',
                'type' => 'required',
                'start_time' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $status = (isset($data['visitor_id'])) ? 2 : 1;
            $sessions = new Sessions();
            $sessions->therapist_id = $data['therapist_id'];
            $sessions->visitor_id = $data['visitor_id'];
            $sessions->start_time = $data['start_time'];
            $sessions->session_date = date('Y-m-d',strtotime($data['start_time']));
            $sessions->type = $data['type'];
            $sessions->status = $status;
            $sessions->session_status = (isset($data['visitor_id'])) ? 'reserved' : 'available';
            $sessions->created_at = date("Y-m-d H:i:s");
            if ($sessions->save()) {

                $this->createMeeting($sessions);
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.sessions'));
                return Redirect::to('admin/sessions/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Sessions  $session
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Sessions  $session
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $session = Sessions::find($id);
        $therapists = Therapist::pluck('title', 'id');
        $visitors = Visitor::with('user')->get()->pluck('user.name', 'id');
        $languages = get_language_trans($id, 'sessions');
        if (!empty($session)) {
            $sessionTimesChanges=SessionsTimesChanges::where('session_id',$session->id)->pluck('session_from_date','session_to_date')->toArray();
            return view('admin.sessions.edit', compact('session', 'languages', 'therapists', 'visitors','sessionTimesChanges'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Sessions  $session
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $sessions = Sessions::find($id);
        if (!empty($sessions)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'therapist_id' => 'required',
                    'visitor_id' => 'required',
                    'type' => 'required',
                    'start_time' => 'required',
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {


                if($data['therapist_start_date'] == 'done')
                {
                    $sessions->therapist_start_date = date('Y-m-d H:i:s');
                }
                else
                {
                    $sessionCount=Sessions::where('therapist_id',$sessions->therapist_id)->where(function($q)use($request,$sessions){
                    //$date=getConvertToMySqlDate($request->start_time);
                    $date=$sessions->start_time;
                    $q->whereBetween('start_time',[date('Y-m-d H:i:s',strtotime($date)),date('Y-m-d H:i:s',strtotime($date.' +'.$sessions->type.' minutes '))])
                        ->orWhere(function($q)use($request,$sessions,$date){
                            $q->where('start_time','>=',date('Y-m-d H:i:s',strtotime($date)))
                                ->where('start_time','<=',date('Y-m-d H:i:s',strtotime($date.' +'.$sessions->type.' minutes ')));
                        })->orWhere(function($q)use ($request,$sessions,$date){
                            $start_time=date('Y-m-d H:i:s',strtotime($date));
                            $end_time=date('Y-m-d H:i:s',strtotime($date.' +'.$sessions->type.' minutes '));
                            $q->whereRaw("'$start_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL type MINUTE)")
                                ->orWhereRaw("'$end_time' BETWEEN start_time AND DATE_ADD(start_time,INTERVAL type MINUTE)");
                        });

                    //->orWhereRaw("'$curentDate' BETWEEN start_time AND DATE_ADD(start_time, INTERVAL type MINUTE)")
                    ;
                })->whereNotIn('session_status',['cancelled','visitor_cancelled'])->where('id','!=',$sessions->id);
                $sessionCount=$sessionCount->count();
                //dd($sessionCount);
                if ( $sessionCount> 0){
                    Session::flash('error', trans('home.This session date is already added or have session between this date'));
                    return  redirect()->back();
                }
                $status = (isset($data['status'])) ? 1 : 0;
                $sessions->therapist_id = $data['therapist_id'];
                $sessions->visitor_id = $data['visitor_id'];
                $sessions->session_date = date('Y-m-d',strtotime($data['start_time']));
                $sessions->start_time = $data['start_time'];
                $sessions->type = $data['type'];
                $sessions->updated_at = date("Y-m-d H:i:s");
                }

                if ($sessions->save()) {
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.sessions'));
                    return Redirect::to('admin/sessions/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Sessions  $session
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $sessions = Sessions::find($id);
        if (!empty($sessions)) {
            //            $sessions->deleted_by=Auth::user()->id;
            $sessions->save();
            if ($sessions->delete()) {
                Session::flash('success', Lang::get('main.sessions') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/sessions');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $session = Sessions::find($id);
            if ($active == 0) {
                $session->active = 0;
            } elseif ($active == 1) {
                $session->active = 1;
            }
            $session->save();
        } else {
            return redirect(404);
        }
    }
    public function booking(Request $request){
        if($request->ajax()){
            if($request->getVisitor){
                $search=$request->emailOrPhone;
                $user=User::select('users.*','visitors.gender','visitors.birthyear','visitors.mobile','visitors.image','visitors.id AS visitor_id')->join('visitors','visitors.user_id','=','users.id')->where(function($q)use($search){$q->where('users.name','LIKE',"%$search%")->orWhere('users.email','LIKE',"%$search%")->orWhere('visitors.mobile','LIKE',"%$search%");})->where('users.type','visitors')->first();
                $html=view('admin.sessions.include.search_block',compact('user'))->render();

                return response()->json(['success'=>($user?true:false),'html'=>$html,'visitor_id'=>($user)?$user->visitor_id:0]);
            }
            if($request->getDatesOfTherapist){
                $sessions=Sessions::where('therapist_id',$request->therapist_id)->whereRaw('session_date>=DATE_FORMAT(NOW(),"%Y-%m-%d")')->groupBy('session_date')->pluck('session_date')->toArray();
                $html='<option value="">Select Date</option>';
                foreach ($sessions as $date){
                    $html.='<option value="'.$date->format('Y-m-d').'">'.$date->format('Y-m-d').'</option>';
                }
                return response()->json(['success'=>true,'html'=>$html]);
            }
            if($request->getSessionsByDate){
                $currency=$request->currency;
                $sessions=Sessions::where('therapist_id',$request->therapist_id)->where('session_date',$request->date)->where('session_status','available')->whereRaw('start_time>=NOW()')->orderBy('start_time')->get();
                $html=view('admin.sessions.include.sessions',compact('sessions','currency'))->render();
                return response()->json(['success'=>true,'html'=>$html]);
            }
            return response()->json(['success'=>false]);
        }
        return view('admin.sessions.booking');
    }
    public function bookingNow(Request $request){
        $visitor=Visitor::find($request->visitor_id);
        $userId=User::find($visitor->user_id);
        if(!$visitor){
            return response()->json(['success'=>false,'message'=>'No Visitor']);
        }
        $session=Sessions::where('therapist_id',$request->therapist_id)->where('id',$request->session_id)->where('session_status','available')->first();
        if(!$session){
            return response()->json(['success'=>false,'message'=>'Session Not Available']);
        }
        $therapist=Therapist::find($request->therapist_id);
        if(!$therapist){
            return response()->json(['success'=>false,'message'=>'No Therapist']);
        }

        $currency=$request->currency;
        $amount=(in_array($session->type,['3','10','30'])?($currency=='EGP'?$therapist->price30:$therapist->thirty_price_dollar):($currency=='EGP'?$therapist->price60:$therapist->sixty_price_dollar));
         $coupon_id=0;
            $coupon_code='';
            $coupon_discount=0;
            $discount_amount=0;

        // Add Coupon
        if($request->coupon){
            $coupon=Coupons::where('code',$request->coupon)->first();
            if($coupon){



                if($coupon->therapists != '' && !in_array($therapist->id,explode(',',$coupon->therapists)))
                {
                    return response()->json(['success'=>false,'class' => 'alert-danger','message'=>trans('home.notforthis')]);
                }

                if($coupon->used_for_session!='all'&&$coupon->used_for_session!=$session->type){
                    return response()->json(['success'=>false,'message'=>trans('home.This coupon not for this type of sessions')]);
                }
                if($coupon->currency!='all'&&$coupon->currency!=$currency){
                    return response()->json(['success'=>false,'message'=>trans('home.This coupon not for currency').trans('home.'.$currency)]);
                }
                if($coupon->used_limit!=0 && $coupon->used_limit<=$coupon->used){
                    return response()->json(['success'=>false,'message'=>trans('home.This coupon used for limited users')]);
                }
                if($coupon->expired_date<date('Y-m-d')){
                    return response()->json(['success'=>false,'message'=>trans('home.This coupon expired')]);
                }
                $coupon_id=$coupon->id;
                $coupon_code=$coupon->code;
                $coupon_discount=$coupon->percentage;
                $discount_amount=($amount*$coupon_discount)/100;
                $amount=$amount-$discount_amount;

                if(CouponsUsed::where('user_id', $userId->id)->where('coupon_id', $coupon->id)->count() <= $coupon->per_user)
                {
                    CouponsUsed::create([
                       'session_id'=>$session->id,
                       'user_id'=>$userId->id,
                       'coupon_id'=>$coupon->id,
                       'payment_id'=>0,
                   ]);
                    $coupon->used++;
                    $coupon->save();
                }
                else
                {
                    return response()->json(['success'=>false,'message'=>trans('home.This coupon used before')]);
                }



            }
            else
            {
                return response()->json(['success'=>false, 'class' => 'alert-danger' ,'message'=>trans('home.This coupon not valid')]);
            }
        }


        $attributes = [
            'visitor_id' => $visitor->id,
            'status' => '2',
            'session_status' => 'reserved',
            'patient_cancel' => 'no',
            'reserved_date' => date('Y-m-d H:i:s'),
            'payment_method'=>$request->payment_method,
            'topic' =>$request->real_or_test,
        ];
        Sessions::where('id',$session->id)->update($attributes);
        $session=Sessions::where('id',$session->id)->with('visitor')->with('therapist')->first();
        $dolarRate=getAppSetting('dolar_rating');
        if(!$dolarRate){
            $dolarRate=1;
        }


        $therapistUser=$session->therapist->user;
        $visitorUser=$visitor->user;
        $patientemail=$visitorUser->email;
        $therapistemail=$therapistUser->email;
        $patientname=$visitorUser->name;
        $therapistname=$therapistUser->name;
        $allsessions=$session;
        $html = view('email.session_payed',compact('visitorUser','therapistUser','allsessions'))->render();
        $sendp=sendGridEmailToUser($html,$patientemail, $patientname, 'Session Payed');
        setTimeZone($therapistUser->timezone?$therapistUser->timezone:'Africa/Cairo');

        $html = view('email.session_payed_therapist',compact('visitorUser','therapistUser','allsessions'))->render();
        $sendt=sendGridEmailToUser($html,$therapistemail, $therapistname, 'Session Payed');










        $payment=new Payments();
        $payment->user_id=$session->visitor->user->id;
        $payment->therapist_id=$session->visitor->user->id;
        $payment->session_id=$session->id;
        $payment->payment_session_id=$request->session_id;
        $payment->transaction_id=NULL;
        $payment->status=$request->status?$request->status:'approved';
        $payment->action=null;
        $payment->html_body_content=null;
        $payment->price=($session->type==30)?$therapist->price30:$therapist->price60;
        $payment->price_dolar=($session->type==30)?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar;
        $payment->amount=$amount;
        $payment->payment_method=$request->payment_method;
        $payment->currancy=$currency;
        $payment->dolar_rating=$dolarRate;
        $payment->add_date=date('Y-m-d H:i:s');
        $payment->save();
        /*$invoice=new TherapistsInvoices();
        $invoice->therapist_id=$therapist->id;
        $invoice->visitor_id=$visitor->id;
        $invoice->session_id=$session->id;
        $invoice->visitor_name=$visitorUser->name;
        $invoice->session_date=$session->start_time;
        $invoice->therapist_price=(in_array($session->type,['30','3']))?$therapist->price30:$therapist->price60;
        $invoice->therapist_price_dolar=(in_array($session->type,['30','3']))?$therapist->thirty_price_dollar:$therapist->sixty_price_dollar;
        $invoice->session_type=$session->type;
        $invoice->total_amount=$amount;
        $invoice->currency=$currency;
        $invoice->discount_amount=0;
        $invoice->discount_percentage=0;
        $invoice->coupon_id=0;
        $invoice->coupon_code='';
        $invoice->total_after_discount=$invoice->total_amount- $invoice->discount_amount;
        $invoice->dolar_rating=$dolarRate;
        $invoice->website_percentage=getAppSetting('website_percentage');
        $invoice->minimum_price_30=getAppSetting('minimum_price_30');
        $invoice->minimum_price_60=getAppSetting('minimum_price_60');
        $invoice->minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
        $invoice->minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
        $minimum_price=0;
        if(in_array($session->type,[30,3])){
            if($invoice->currency=='EGP'){
                $minimum_price=$invoice->minimum_price_30;
            }else{
                $minimum_price=$invoice->minimum_price_30_dolar;
            }
        }
        if(in_array($session->type,[60,6])){
            if($invoice->currency=='EGP'){
                $minimum_price=$invoice->minimum_price_60;
            }else{
                $minimum_price=$invoice->minimum_price_60_dolar;
            }
        }
        $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);
        $invoice->save();*/
        //Sessions::where('id',$session->id)->update(['invoice_id'=>$invoice->id]);



            $visitorUser = $session->visitor->user;

            $invoice = new TherapistsInvoices();
            $invoice->therapist_id = $therapist->id;
            $invoice->visitor_id = $visitor->id;
            $invoice->session_id = $session->id;
            $invoice->visitor_name = $visitorUser->name;
            $invoice->session_date = $session->start_time;
            $invoice->therapist_price = (in_array($session->type, ['30', '3','10'])) ? $therapist->price30 : $therapist->price60;
            $invoice->therapist_price_dolar = (in_array($session->type, ['30', '3','10'])) ? $therapist->thirty_price_dollar : $therapist->sixty_price_dollar;
            $invoice->session_type = $session->type;
            $invoice->total_amount = $amount;
            $invoice->currency = $currency;



           $invoice->website_percentage=getAppSetting('website_percentage');
           $invoice->minimum_price_30=getAppSetting('minimum_price_30');
           $invoice->minimum_price_60=getAppSetting('minimum_price_60');
           $invoice->minimum_price_30_dolar=getAppSetting('minimum_price_30_dolar');
           $invoice->minimum_price_60_dolar=getAppSetting('minimum_price_60_dolar');
           $minimum_price=0;


           if ($currency == 'USD')
           {
               if(in_array($session->type,[30,3,10])){
                $minimum_price=$invoice->minimum_price_30_dolar;
               }
               else{
                    $minimum_price=$invoice->minimum_price_60_dolar;
               }
           }
           elseif($currency == 'EGP')
           {

               if(in_array($session->type,[30,3,10])){
                $minimum_price=$invoice->minimum_price_30;
               }
               else{
                    $minimum_price=$invoice->minimum_price_60;
               }

           }


           if($discount_amount > 0)
           {
            $therDiscount = ($discount_amount/2);

            $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price) + $therDiscount;
           }
           else
           {
            $invoice->therapist_amount=calculateTherapistAmount($invoice->total_amount,$invoice->website_percentage,$minimum_price);
           }

           if($request->coupon){
                $coupon=Coupons::where('code',$request->coupon)->first();
                if($coupon)
                {
                    $coupon_id=$coupon->id;
                    $coupon_code=$coupon->code;
                    $coupon_discount=$coupon->percentage;
                }
           }

           else{
                $coupon_id=0;
                $coupon_code='';
                $coupon_discount=0;
           }

            $invoice->discount_amount = $discount_amount;
            $invoice->discount_percentage = $coupon_discount;
            $invoice->coupon_id = $coupon_id;
            $invoice->coupon_code =  $coupon_code;
            $invoice->total_after_discount = $invoice->total_amount;
            $invoice->dolar_rating = 0;
            $invoice->save();
            Sessions::where('id', $session->id)->update(['invoice_id' => $invoice->id]);

        return response()->json(['success'=>true,'message'=>'Success Booking Session']);
    }


    public function getTherapists(Request $request){
        if($request->ajax()){
            $therapists=Therapist::select('therapists.id','name_a AS text');
            if($request->q){
                $therapists=$therapists->where(function ($q)use($request){$q->where('name_e','LIKE',"%$request->q%")->orWhere('name_a','LIKE',"%$request->q%")->orWhere('title','LIKE',"%$request->q%");});
            }
            $therapists=$therapists->take(50)->get();
            return response()->json(['results'=>$therapists]);
        }
    }
}
