<?php

namespace App\Http\Controllers\Admin;

use App\Sliders;
use App\WebsiteLanguages;
use App\Profiles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Rules\FilterStringRule;
use Yajra\DataTables\Facades\DataTables;
class AdminSliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      /*  $search=$request->input('search');
        if($search){
            $sliders=Sliders::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $sliders=Sliders::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.sliders.view',compact('sliders'));*/

        if ($request->ajax()) {

            $sliders=Sliders::orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $sliders = $sliders->where('active', 1);
                       break;
                   case 'unactive':
                       $sliders = $sliders->where('active', 0);
                       break;
               }
           }

           return DataTables::of($sliders)
               ->addIndexColumn()


               ->editColumn('picture', function ($slider) {
                   return '<img style="height: 100px;width: 100px;" src="' . asset('slider/'.$slider->picture) . '"   alt="">';
               })

               ->addColumn('active', function ($slider) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $slider->id . '" type="checkbox" ' . (!PerUser('sliders_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('sliders_active') ? 'changeStatues' : '') . '"  ' . (($slider->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $slider->id . '"><label for="checkbox-' . $slider->id . '"></label></div>';
               })
               ->addColumn('action', function ($slider) {
                   return '
           ' . (PerUser('sliders_edit') ? '<a class="btn btn-success" href="' . URL('admin/sliders/' . $slider->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('sliders_delete') ? '<a class="btn btn-danger" href="' . URL('sliders_delete/'. $slider->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action', 'picture'])
               ->make(true);
       }
       return view('admin.sliders.view');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default','desc')->get();
        return view('admin.sliders.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'title_ar'=>['string','nullable'],
                'title_en'=>['string','nullable'],
                'description_ar'=>['string','nullable'],
                'description_en'=>['string','nullable'],
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active=(isset($data['active']))?1:0;
            $sliders=new Sliders();
            $sliders->title_ar=$data['title_ar'];
            $sliders->title_en=$data['title_en'];
            $sliders->description_ar=$data['description_ar'];
            $sliders->description_en=$data['description_en'];
            if($request->hasFile('picture')){
                $validator = Validator::make($request->all(),array(
                    'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                }else{
                    $file=$request->file('picture');
                    $image=FileImage($file,'slider','picture');
                    $sliders->picture=$image['img'];
                }
            }
            $sliders->active=$active;
            $sliders->created_at=date("Y-m-d H:i:s");
            if($sliders->save()){
//                save_all_trans($data,$sliders->id,'sliders',['title'=>'titles','description'=>'descriptions']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.sliders'));
                return Redirect::to('admin/sliders/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id,'sliders');
        $slider=Sliders::find($id);
        if(!empty($slider)){
            return view('admin.sliders.edit',compact('slider','languages'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $sliders= Sliders::find($id);
        if(!empty($sliders)){
            $validator = Validator::make($request->all(),
                array(
                    'title_ar'=>['string','nullable'],
                    'title_en'=>['string','nullable'],
                    'description_ar'=>['string','nullable'],
                    'description_en'=>['string','nullable'],
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                if($request->hasFile('picture')){
                    $validator = Validator::make($request->all(),array(
                        'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }else{
                        if(file_exists(public_path().$sliders->img_dir.$sliders->img)&&!empty($sliders->img_dir)){
                            unlink(public_path().$sliders->img_dir.$sliders->img);
                        }
                        $file=$request->file('picture');
                        $image=FileImage($file,'slider');
                        $sliders->picture=$image['img'];
                    }
                }
                $active=(isset($data['active']))?1:0;
                $sliders->title_ar=$data['title_ar'];
                $sliders->title_en=$data['title_en'];
                $sliders->description_ar= $data['description_ar'];
                $sliders->description_en= $data['description_en'];
                $sliders->active=$active;
                $sliders->updated_at=date("Y-m-d H:i:s");
                if($sliders->save()){
//                    save_all_trans($data,$id,'sliders',['title'=>'titles','description'=>'descriptions']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.sliders'));
                    return Redirect::to('admin/sliders/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $sliders=Sliders::find($id);
        if(!empty($sliders)){
//            $sliders->deleted_by=Auth::user()->id;
            $sliders->save();
            if($sliders->delete()){
                Session::flash('success', Lang::get('main.sliders') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/sliders');
            }
        }
    }

    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $slider=Sliders::find($id);
            if ($active == 0) {
                $slider->active = 0;
            } elseif ($active == 1) {
                $slider->active = 1;
            }
            $slider->save();
        }else{
            return redirect(404);
        }
    }
}
