<?php

namespace App\Http\Controllers\Admin;

use App\Specialties;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminSpecialistController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      /*  $search=$request->input('search');
        $parents = Specialties::orderBy('sort','ASC')->pluck('title_ar','id');
        if($search){
            $specialties=Specialties::where('title_ar','LIKE',"%$search%")->orderBy('sort','ASC')->paginate(100);
        }else{
            $specialties=Specialties::orderBy('sort','ASC')->paginate(100);
        }
        return view('admin.specialties.view',compact('specialties','parents'));*/

        if ($request->ajax()) {

            $specialties=Specialties::orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $specialties = $specialties->where('active', 1);
                       break;
                   case 'unactive':
                       $specialties = $specialties->where('active', 0);
                       break;
               }
           }

           return DataTables::of($specialties)
               ->addIndexColumn()



               ->addColumn('active', function ($specialties) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $specialties->id . '" type="checkbox" ' . (!PerUser('specialties_view') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('specialties_view') ? 'changeStatues' : '') . '"  ' . (($specialties->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $specialties->id . '"><label for="checkbox-' . $specialties->id . '"></label></div>';
               })
               ->addColumn('action', function ($specialties) {
                   return '
           ' . (PerUser('specialties_edit') ? '<a class="btn btn-success" href="' . URL('admin/specialties/' . $specialties->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('specialties_delete') ? '<a class="btn btn-danger" href="' . URL('specialties_delete/'. $specialties->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.specialties.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $parents = Specialties::orderBy('sort','ASC')->pluck('title_ar','id');
//        $languages = WebsiteLanguages::orderBy('default','desc')->get();
        return view('admin.specialties.add',compact('parents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'title_ar'=>'required',
                'title_en'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active=(isset($data['active']))?1:0;
            $specialties=new Specialties();
            $specialties->title_ar=$data['title_ar'];
            $specialties->title_en=$data['title_en'];
            $specialties->parent_id=$data['parent_id'];
            $specialties->active=$active;
            $specialties->sort=$request->sort;
            $specialties->created_at=date("Y-m-d H:i:s");
            if($specialties->save()){
//                save_all_trans($data,$specialties->id,'specialties',['title'=>'titles']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.specialties'));
                return Redirect::to('admin/specialties/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Specialties  $specialist
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Specialties  $specialist
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $specialist=Specialties::find($id);
        $parents = Specialties::orderBy('sort','ASC')->pluck('title_ar','id');
//        $languages = get_language_trans($id,'specialties');
        if(!empty($specialist)){
            return view('admin.specialties.edit',compact('specialist','parents'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Specialties  $specialist
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data=$request->input();
        $specialties= Specialties::find($id);
        if(!empty($specialties)){
            $validator = Validator::make($request->all(),
                array(
                    'title_ar'=>'required',
                    'title_en'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $active=(isset($data['active']))?1:0;
                $specialties->title_ar=$data['title_ar'];
                $specialties->title_en=$data['title_en'];
                $specialties->parent_id=$data['parent_id'];
                $specialties->active=$active;
                $specialties->sort=$request->sort;
                $specialties->updated_at=date("Y-m-d H:i:s");
                if($specialties->save()){
//                    save_all_trans($data,$id,'specialties',['title'=>'titles']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.specialties'));
                    return Redirect::to('admin/specialties/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Specialties  $specialist
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $specialties=Specialties::find($id);
        if(!empty($specialties)){
//            $specialties->deleted_by=Auth::user()->id;
            $specialties->save();
            if($specialties->delete()){
                Session::flash('success', Lang::get('main.specialties') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/specialties');
            }
        }
    }
    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $specialties=Specialties::find($id);
            if ($active == 0) {
                $specialties->active = 0;
            } elseif ($active == 1) {
                $specialties->active = 1;
            }
            $specialties->save();
        }else{
            return redirect(404);
        }
    }
}
