<?php

namespace App\Http\Controllers\Admin;

use App\StaticPage;
use App\WebsiteLanguages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class AdminStaticPageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /*  $search=$request->input('search');
        if($search){
            $static_pages=StaticPage::where('title','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $static_pages=StaticPage::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.static_pages.view',compact('static_pages'));*/


        if ($request->ajax()) {

            $static_pages = StaticPage::orderBy('id', 'DESC');


            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $static_pages = $static_pages->where('active', 1);
                        break;
                    case 'unactive':
                        $static_pages = $static_pages->where('active', 0);
                        break;
                }
            }

            return DataTables::of($static_pages)
                ->addIndexColumn()


                ->addColumn('active', function ($static_page) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $static_page->id . '" type="checkbox" ' . (!PerUser('static_pages_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('profiles_active') ? 'changeStatues' : '') . '"  ' . (($static_page->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $static_page->id . '"><label for="checkbox-' . $static_page->id . '"></label></div>';
                })
                ->addColumn('action', function ($static_page) {
                    return '
            ' . (PerUser('static_pages_edit') ? '<a class="btn btn-success" href="' . URL('admin/static_pages/' . $static_page->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
            ' . (PerUser('static_pages_delete') ? '<a class="btn btn-danger" href="' . URL('static_pages_delete/'. $static_page->id) .  '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
            ';
                })

                ->rawColumns(['active', 'action'])
                ->make(true);
        }
        return view('admin.static_pages.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default', 'desc')->get();
        return view('admin.static_pages.add', compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'title_ar' => 'required',
                'title_en' => 'required',
                'body_ar' => 'required',
                'body_en' => 'required',
                'url_ar' => 'required|unique:static_pages,url_ar',
                'url_en' => 'required|unique:static_pages,url_en',
                'meta_title_ar' => 'required',
                'meta_title_en' => 'required',
                'meta_descripetion_ar' => 'required',
                'meta_descripetion_en' => 'required',
                'meta_keywords' => 'required'


            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $static_pages = new StaticPage();
            $static_pages->title_ar = $data['title_ar'];
            $static_pages->title_en = $data['title_en'];
            $static_pages->body_ar = $data['body_ar'];
            $static_pages->body_en = $data['body_en'];
            $static_pages->url_ar = $data['url_ar'];
            $static_pages->url_en = $data['url_en'];
            $static_pages->meta_title_ar = $data['meta_title_ar'];
            $static_pages->meta_title_en = $data['meta_title_en'];
            $static_pages->meta_descripetion_ar = $data['meta_descripetion_ar'];
            $static_pages->meta_descripetion_en = $data['meta_descripetion_en'];
            $static_pages->meta_keywords = $data['meta_keywords'];

            $static_pages->active = $active;
            $static_pages->created_at = date("Y-m-d H:i:s");
            if ($static_pages->save()) {
                //                save_all_trans($data,$static_pages->id,'static_pages',['title'=>'titles','body'=>'bodies']);
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.static_pages'));
                return Redirect::to('admin/static_pages/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\StaticPage  $static_page
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\StaticPage  $static_page
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id, 'static_pages');
        $static_page = StaticPage::find($id);
        if (!empty($static_page)) {
            return view('admin.static_pages.edit', compact('static_page', 'languages'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\StaticPage  $static_page
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $static_pages = StaticPage::find($id);
        if (!empty($static_pages)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'title_ar' => 'required',
                    'body_ar' => 'required',
                    'url_ar' => 'required',
                    'title_en' => 'required',
                    'body_en' => 'required',
                    'url_en' => 'required',
                    'meta_title_ar' => 'required',
                    'meta_title_en' => 'required',
                    'meta_descripetion_ar' => 'required',
                    'meta_descripetion_en' => 'required',
                    'meta_keywords' => 'required'
                )
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                $active = (isset($data['active'])) ? 1 : 0;
                $static_pages->title_ar = $data['title_ar'];
                $static_pages->body_ar = $data['body_ar'];
                $static_pages->url_ar = $data['url_ar'];
                $static_pages->title_en = $data['title_en'];
                $static_pages->body_en = $data['body_en'];
                $static_pages->url_en = $data['url_en'];
                $static_pages->meta_title_ar = $data['meta_title_ar'];
                $static_pages->meta_title_en = $data['meta_title_en'];
                $static_pages->meta_descripetion_ar = $data['meta_descripetion_ar'];
                $static_pages->meta_descripetion_en = $data['meta_descripetion_en'];
                $static_pages->meta_keywords = $data['meta_keywords'];
                $static_pages->active = $active;
                $static_pages->updated_at = date("Y-m-d H:i:s");
                if ($static_pages->save()) {
                    //                    save_all_trans($data,$id,'static_pages',['title'=>'titles','body'=>'bodies']);
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.static_pages'));
                    return Redirect::to('admin/static_pages/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\StaticPage  $static_page
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $static_pages = StaticPage::find($id);
        if (!empty($static_pages)) {
            //            $static_pages->deleted_by=Auth::user()->id;
            $static_pages->save();
            if ($static_pages->delete()) {
                Session::flash('success', Lang::get('main.static_pages') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/static_pages');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $static_page = StaticPage::find($id);
            if ($active == 0) {
                $static_page->active = 0;
            } elseif ($active == 1) {
                $static_page->active = 1;
            }
            $static_page->save();
        } else {
            return redirect(404);
        }
    }
}
