<?php

namespace App\Http\Controllers\Admin;

use App\Certificates;
use App\Countries;
use App\Education;
use App\Experience;
use App\Exports\PaymentsExport;
use App\Exports\TherapistsExport;
use App\MainFocus;
use App\Specialties;
use App\Therapist;
use App\Therapists_languages;
use App\TherapistsMainFocus;
use App\TherapistsSpecialties;
use App\Visitor;
use App\WebsiteLanguages;
use App\Languages;
use App\Profiles;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;
use App\TherapistsPictures;
use Illuminate\Support\Facades\Hash;
class AdminTherapistController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if ($request->ajax()) {
            $therapists = Therapist::select('therapists.id','therapists.user_id', 'therapists.active', 'therapists.archive', 'users.name','users.email', 'therapists.name_a', 'therapists.picture', 'main_specialty_ar', 'main_specialty_en', 'resume')->leftJoin('users', 'users.id', '=', 'therapists.user_id');
            if (isset($request->order[0]['column']) && $request->order[0]['column'] == 6) {
                $therapists = $therapists->orderBy('active', $request->order[0]['dir']);
            }
            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $therapists = $therapists->where('therapists.active', 1);
                        break;
                    case 'unactive':
                        $therapists = $therapists->where('therapists.active', 0);
                        break;
                    case 'archive':
                        $therapists = $therapists->where('therapists.archive', 1);
                        break;
                    case 'unarchive':
                        $therapists = $therapists->where('therapists.archive', 0);
                        break;
                }
            }
            return DataTables::of($therapists)
                ->addIndexColumn()
                ->editColumn('picture', function ($therapist) {
                    return '<img style="height: 100px;width: 100px;" src="' . asset('avatars/therapists/' . $therapist->picture) . '" alt="">';
                })->editColumn('resume', function ($therapist) {
                    return (!empty($therapist->resume)) ? '<a target="_blank" href="' . url('resumes/' . $therapist->resume) . '"><i class="fa fa-download"></i></a>' : '';
                })
                ->addColumn('active', function ($therapist) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $therapist->id . '" type="checkbox" ' . (!PerUser('therapists_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('therapists_active') ? 'changeStatues' : '') . '"  ' . (($therapist->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $therapist->id . '"><label for="checkbox-' . $therapist->id . '"></label></div>';
                })
                ->addColumn('archive', function ($therapist) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $therapist->id . '" type="checkbox" ' . (!PerUser('therapists_archive') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('therapists_archive') ? 'changeArchiveStatues' : '') . '"  ' . (($therapist->archive == 1) ? 'checked="checked"' : '') . ' id="archive-checkbox-' . $therapist->id . '"><label for="archive-checkbox-' . $therapist->id . '"></label></div>';
                })
                ->addColumn('reset', function ($therapist) {
                    return ' ' . (PerUser('therapists_reset') ? '<a class="btn btn-primary" href="' . URL('therapists_reset/'. $therapist->user_id) . '"><i class="fa fa-key"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '';

                })
                ->addColumn('action', function ($therapist) {
                    if ($therapist->active==0)  {
                        return '
                        ' . (PerUser('therapists_edit') ? '<a class="btn btn-success" href="' . URL('admin/therapists/' . $therapist->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
                        ' . (PerUser('therapists_delete') ? '<a class="btn btn-danger" href="' . URL('therapists_delete/'. $therapist->id)  . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                        ' .  '<a class="btn btn-danger sendEmailAgainss" href="javascript:;" title="Send Complete Register Link" data-id="' . $therapist->user_id . '"><i class="fa fa-paper-plane" aria-hidden="true"></i>' ./*Lang::get('main.delete').*/ '</a>'  . '
                       '. '<a class="btn btn-primary copylinkhh" href="javascript:;" title="Copy Complete Register Link" data-id="' . $therapist->id . '"><i class="fa fa-copy" aria-hidden="true"></i>' ./*Lang::get('main.delete').*/ '</a>' . '

                        ';
                    }else{
                    return '
                        ' . (PerUser('therapists_edit') ? '<a class="btn btn-success" href="' . URL('admin/therapists/' . $therapist->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
                        ' . (PerUser('therapists_delete') ? '<a class="btn btn-danger" href="' . URL('therapists_delete/'. $therapist->id)  . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                                    ';}
                })
                //               ->addColumn('discount_code', function($sessionInfo){
                //                    return'';
                //                })
                ->rawColumns(['active','archive','reset', 'action', 'picture', 'resume'])
                ->make(true);
        }
        return view('admin.therapists.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Countries::pluck('title_ar', 'id');
        $languages = Languages::pluck('title_ar', 'id');
        $specialties = Specialties::active()->orderBy('sort', 'ASC')->pluck('title_ar', 'id');
        $certificates = Certificates::where('therapist_id', null)->pluck('name_ar', 'id');
        $educations = Education::where('therapist_id', null)->pluck('name_ar', 'id');
        $experiences = Experience::where('therapist_id', null)->pluck('name_ar', 'id');
        $users = User::whereRaw('id NOT IN (select user_id from therapists)')->pluck('name', 'id');
        return view('admin.therapists.add', compact('languages', 'users', 'countries', 'specialties', 'certificates', 'educations', 'experiences'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'name_a' => 'required',
                'name_e' => 'required',
                'gender' => 'required',
                'main_specialty_ar' => 'required',
                'main_specialty_en' => 'required',
                'price30' => 'required',
                'price60' => 'required',
                'thirty_price_dollar' => 'required',
                'sixty_price_dollar' => 'required',
                'certifications_ar' => 'required',
                'certifications_en' => 'required',
                'experience_ar' => 'required',
                'experience_en' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $therapists = new Therapist();
            $therapists->mobile = $data['mobile'];
            $therapists->name_a = $data['name_a'];
            $therapists->name_e = $data['name_e'];
            $therapists->license_no = $data['license_no'];
            $therapists->license_org = $data['license_org'];
            $therapists->gender = $data['gender'];
//            $therapists->main_focus_ar = $data['main_focus_ar'];
//            $therapists->main_focus_en = $data['main_focus_en'];
            // $main_focus_ar='';
            // $main_focus_en='';
            // if($request->main_focus){
            //     $main_focus_ar=implode(',',MainFocus::whereIn('id',$request->main_focus)->pluck('title_ar')->toArray());
            //     $main_focus_en=implode(',',MainFocus::whereIn('id',$request->main_focus)->pluck('title_en')->toArray());
            // }

            // $therapists->main_focus_ar      = $main_focus_ar;
            // $therapists->main_focus_en      = $main_focus_en;

            $therapists->description_ar = $data['description_ar'];
            $therapists->description_en = $data['description_en'];
            $therapists->summery_ar = $data['summery_ar'];
            $therapists->summery_en = $data['summery_en'];
            $therapists->user_id = $data['user_id'];
            $therapists->country_id = $data['country_id'];
            $therapists->price30 = $data['price30'];
            $therapists->price60 = $data['price60'];
            $therapists->thirty_price_dollar = $data['thirty_price_dollar'];
            $therapists->sixty_price_dollar = $data['sixty_price_dollar'];
            $therapists->main_specialty_ar = $data['main_specialty_ar'];
            $therapists->main_specialty_en = $data['main_specialty_en'];
            $therapists->experience_ar = $data['experience_ar'];
            $therapists->experience_en = $data['experience_en'];
            $therapists->certifications_ar = $data['certifications_ar'];
            $therapists->certifications_en =  $data['certifications_en'];
            $therapists->language_id = $data['language_id'];
            

                if(isset($data['rating']))
                {
                    $therapists->rating = $data['rating'];
                }
                else
                {
                    $therapists->rating = 1;
                }

                if($request->main_focus)
                {
                    $therapists->main_focus = implode(',' , $request->main_focus);
                }

            $therapists->birth = date("Y-m-d", strtotime($data['birth']));
            if ($request->hasFile('picture')) {
                $validator = Validator::make($request->all(), array(
                    'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                } else {
                    $image_name = time() . '.' . $request->file('picture')->getClientOriginalExtension();
                    $destinationPath = public_path('avatars/therapists');
                    $request->file('picture')->move($destinationPath, $image_name);
                    $therapists->picture = $image_name;
                }
            }
            if ($request->hasFile('resume')) {
                $validator = Validator::make($request->all(), array(
                    ['resume' => 'required|mimes:pdf,doc,docx,zip'],
                ));
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator->errors())->withInput();
                } else {
                    $file = $request->file('resume');
                    $destinationPath = public_path('resumes/' . $therapists->id . '/');
                    $fileName = $file->getClientOriginalName();
                    $file->move($destinationPath, $fileName);
                    $therapists->resume = $fileName;
                }
            }
            $therapists->active = $active;
            $therapists->created_at = date("Y-m-d H:i:s");
            if ($therapists->save()) {
                if (isset($data['specialties']) && !empty($data['specialties'])) {
                    foreach ($data['specialties'] as $specialty_id) {
                        $th_sp = new TherapistsSpecialties();
                        $th_sp->therapist_id = $therapists->id;
                        $th_sp->speciality_id = $specialty_id;
                        $th_sp->save();
                    }
                }
                // $ids=[];
                // if($request->main_focus){

                //     foreach ($request->main_focus as $main_focus_id){
                //         $therapistsMainFocus=TherapistsMainFocus::where('therapist_id',$therapists->id)->where('main_focus_id',$main_focus_id)->first();
                //         if(!$therapistsMainFocus){
                //             $therapistsMainFocus=new TherapistsMainFocus();
                //             $therapistsMainFocus->therapist_id=$therapists->id;
                //             $therapistsMainFocus->main_focus_id=$main_focus_id;
                //             $therapistsMainFocus->save();
                //         }
                //         $ids[]=$therapistsMainFocus->id;
                //     }
                // }
                // TherapistsMainFocus::where('therapist_id',$therapists->id)->whereNotIn('id',$ids)->delete();
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.therapists'));
                return Redirect::to('admin/therapists/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Therapist  $therapist
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Therapist  $therapist
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        ///get therapist images
        $therapistimages = TherapistsPictures::where('therapists_id', $id)->get();

        $therapist = Therapist::find($id);
        $users = User::pluck('name', 'id');
        $languages = Languages::pluck('title_ar', 'id');
        $countries = Countries::pluck('title_ar', 'id');
        $specialties = Specialties::active()->orderBy('sort', 'ASC')->pluck('title_ar', 'id');
        $certificates = Certificates::where('therapist_id', null)->OrWhere('therapist_id', $id)->pluck('name_ar', 'id');
        $educations = Education::where('therapist_id', null)->OrWhere('therapist_id', $id)->pluck('name_ar', 'id');
        $experiences = Experience::where('therapist_id', null)->OrWhere('therapist_id', $id)->pluck('name_ar', 'id');
        $therapist_specialties = TherapistsSpecialties::where('therapist_id', $id)->pluck('speciality_id', 'id')->ToArray();
        $therapist_certificates = Certificates::where('therapist_id', $id)->pluck('id', 'id')->ToArray();
        $therapist_experiences = Experience::where('therapist_id', $id)->pluck('id', 'id')->ToArray();
        $therapist_educations = Education::where('therapist_id', $id)->pluck('id', 'id')->ToArray();
        $therapist_languages = Therapists_languages::where('therapist_id', $id)->pluck('language_id', 'id')->ToArray();
        if (!empty($therapist)) {
            return view('admin.therapists.edit', compact(
                'therapist',
                'languages',
                'users',
                'countries',
                'specialties',
                'certificates',
                'therapist_certificates',
                'therapist_specialties',
                'educations',
                'experiences',
                'therapist_educations',
                'therapist_experiences',
                'therapist_languages',
                'therapistimages'
            ));
        } else {
            return abort(404);
        }
    }

    /////////////////// save therapist images in ajax
    public function therapistspic(Request $request)
    {

        $data['picture'] = $request->picture;
        Therapist::where('id', $request->id)->update($data);
    }

    //////////////////

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Therapist  $therapist
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $therapists = Therapist::find($id);
        if (!empty($therapists)) {
            $validator = Validator::make(
                $request->all(),
                array(
                  /*  'name_a' => 'required',
                    'name_e' => 'required',
                    'gender' => 'required',
                    'main_specialty_ar' => 'required',
                    'main_specialty_en' => 'required',
                    'price30' => 'required',
                    'price60' => 'required',
                    'thirty_price_dollar' => 'required',
                    'sixty_price_dollar' => 'required',
                    'certifications_ar' => 'required',
                    'certifications_en' => 'required',
                    'experience_ar' => 'required',
                    'experience_en' => 'required',*/
                )
            );
            $active = (isset($data['active'])) ? 1 : 0;
            $validator->after(function($validator)use($therapists,$active,$request){
                if($active==1){
                    if($therapists->picture ==''&&!$request->hasFile('picture')){
                        $validator->errors()->add(
                            'picture', 'picture is empty please complete it '
                        );
                    }
                    if($request->name_a==''){
                        $validator->errors()->add(
                            'name_a', 'Arabic name is empty please complete it '
                        );
                    }
                    if($request->name_e==''){
                        $validator->errors()->add(
                            'name_e', 'english name is empty please complete it '
                        );
                    }
                    if($request->gender==''){
                        $validator->errors()->add(
                            'gender', 'gender is empty please complete it '
                        );
                    }
                    if($request->price30==''){
                        $validator->errors()->add(
                            'price30', 'price half hour by egyption pound  is empty  please complete it'
                        );
                    }
                    if($request->price60==''){
                        $validator->errors()->add(
                            'price60', 'price hour by egyption pound  is empty  please complete it '
                        );
                    }
                }
            });
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {

                if ($request->hasFile('picture')) {
                    $validator = Validator::make($request->all(), array(
                        'picture' => 'required|mimes:jpg,jpeg,bmp,png'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    } else {
                        $file = $request->file('picture');
                        $destinationPath = public_path('avatars/therapists');
                        $fileName = time() . uniqid() . $file->getClientOriginalName();
                        $file->move($destinationPath, $fileName);
                        $therapists->picture = $fileName;
                    }
                }
                if ($request->hasFile('resume')) {
                    $validator = Validator::make($request->all(), array(
                        ['resume' => 'required|mimes:pdf,doc,docx,zip'],
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    } else {
                        $file = $request->file('resume');
                        $destinationPath = public_path('resumes/' . $therapists->id . '/');
                        $fileName = $file->getClientOriginalName();
                        $file->move($destinationPath, $fileName);
                        $therapists->resume = $fileName;
                    }
                }

                $therapists->mobile = $data['mobile'];
                $therapists->name_a = $data['name_a'];
                $therapists->name_e = $data['name_e'];
                $therapists->license_no = $data['license_no'];
                $therapists->license_org = $data['license_org'];
                $therapists->gender = $data['gender'];
//                $therapists->main_focus_ar = $data['main_focus_ar'];
//                $therapists->main_focus_en = $data['main_focus_en'];
                // $main_focus_ar='';
                // $main_focus_en='';
                // if($request->main_focus){
                //     $main_focus_ar=implode(',',MainFocus::whereIn('id',$request->main_focus)->pluck('title_ar')->toArray());
                //     $main_focus_en=implode(',',MainFocus::whereIn('id',$request->main_focus)->pluck('title_en')->toArray());
                // }
                // $therapists->main_focus      = $main_focus_ar;
                // $therapists->main_focus_en      = $main_focus_en;

                $therapists->description_ar = $data['description_ar'];
                $therapists->description_en = $data['description_en'];
                $therapists->summery_ar = $data['summery_ar'];
                $therapists->summery_en = $data['summery_en'];
                $therapists->country_id = $data['country_id'];
                $therapists->price30 = $data['price30'];
                $therapists->price60 = $data['price60'];
                $therapists->thirty_price_dollar = $data['thirty_price_dollar'];
                $therapists->sixty_price_dollar = $data['sixty_price_dollar'];
                $therapists->main_specialty_ar = $data['main_specialty_ar'];
                $therapists->main_specialty_en = $data['main_specialty_en'];
                $therapists->language_id = $data['language_id'];
                $therapists->experience_ar = $data['experience_ar'];
                $therapists->experience_en = $data['experience_en'];
                $therapists->certifications_ar = $data['certifications_ar'];
                $therapists->certifications_en =  $data['certifications_en'];
                $therapists->money_paid_egp =  $data['money_paid_egp'];
                $therapists->money_paid_usd =  $data['money_paid_usd'];

                if(isset($data['rating']))
                {
                    $therapists->rating = $data['rating'];
                }
                else
                {
                    $therapists->rating = 1;
                }

                if($request->main_focus)
                {
                    $therapists->main_focus = implode(',' , $request->main_focus);
                }
                
                
                //$therapists->birth = date("Y-m-d", strtotime($data['birth']));
                $therapists->active = $active;
                $therapists->updated_at = date("Y-m-d H:i:s");
                if ($therapists->save()) {

                    if($therapists->active == 0 && $active == 1)
                    {
                        $html = view('email.activate_account')->render();
                        sendGridEmailToUser($html, $therapists->user->email, $therapists->user->name, 'Account Activated');
                    }

                    TherapistsSpecialties::where('therapist_id', $therapists->id)->delete();
                    if (isset($data['specialties']) && !empty($data['specialties'])) {
                        foreach ($data['specialties'] as $specialty_id) {
                            $th_sp = new TherapistsSpecialties();
                            $th_sp->therapist_id = $therapists->id;
                            $th_sp->speciality_id = $specialty_id;
                            $th_sp->save();
                        }
                    }
                    $ids=[];
                    // if($request->main_focus){

                    //     foreach ($request->main_focus as $main_focus_id){
                    //         $therapistsMainFocus=TherapistsMainFocus::where('therapist_id',$therapists->id)->where('main_focus_id',$main_focus_id)->first();
                    //         if(!$therapistsMainFocus){
                    //             $therapistsMainFocus=new TherapistsMainFocus();
                    //             $therapistsMainFocus->therapist_id=$therapists->id;
                    //             $therapistsMainFocus->main_focus_id=$main_focus_id;
                    //             $therapistsMainFocus->save();
                    //         }
                    //         $ids[]=$therapistsMainFocus->id;
                    //     }
                    // }
                    // TherapistsMainFocus::where('therapist_id',$therapists->id)->whereNotIn('id',$ids)->delete();
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.therapists'));
                    return Redirect::to('admin/therapists/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Therapist  $therapist
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $therapists = Therapist::find($id);
        if (!empty($therapists)) {
            $therapists->save();

            if ($therapists->delete()) {
                User::where('id',$therapists->user_id)->delete();
                Session::flash('success', Lang::get('main.therapists') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/therapists');
            }
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $therapist = Therapist::find($id);




            if ($active == 0) {
                $therapist->active = 0;
            } elseif ($active == 1) {
                if($therapist->picture ==''){
                    return 'picture is empty please complete it ';
                }
                if($therapist->name_a ==''){
                    return 'Arabic name is empty please complete it ';

                }
                elseif($therapist->name_e ==''){
                    return 'english name is empty please complete it';
                }
                elseif($therapist->gender ==''){
                    return 'gender is empty please complete it';
                }
                  /* elseif($therapist->main_specialty_ar ==''){
                    return 'Arabic main specialty is empty please complete it';
                }
             elseif($therapist->main_specialty_en ==''){
                    return 'english main specialty is empty please complete it';
                }*/
                elseif($therapist->price30 ==''){

                    return 'price half hour by egyption pound  is empty  please complete it';
                }
                elseif($therapist->price60 ==''){
                    return 'price hour by egyption pound  is empty  please complete it';
                }
                 /*  elseif($therapist->thirty_price_dollar ==''){
                    return 'price half hour by Dollar  is empty  please complete it';

                }elseif($therapist->sixty_price_dollar ==''){
                    return 'price hour by Dollar  is empty  please complete it';

             }elseif($therapist->certifications_ar ==''){
                    return 'Arabic certifications is  empty please complete it';

                }elseif($therapist->certifications_en ==''){
                    return 'english certifications is  empty please complete it';
                }elseif($therapist->experience_ar ==''){
                    return 'Arabic experience is  empty please complete it';

                }elseif($therapist->experience_en ==''){
                    return 'english experience is  empty please complete it';
                }
                */
            else{
                    echo "active";
                    $therapist->active = 1;
                    $html = view('email.activate_account')->render();
                    sendGridEmailToUser($html, $therapist->user->email, $therapist->user->name, 'Account Activated');
                }


            }
            $therapist->save();
        } else {
            return redirect(404);
        }
    }
    public function archive(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('archive');
            $therapist = Therapist::find($id);
            $therapist->archive = $active;
            $therapist->save();
        } else {
            return redirect(404);
        }
    }

    //downloadResume
    public function downloadResume($id)
    {
        $therapistData = Therapist::findOrFail($id);
        $file = public_path() . "/resumes/" . $therapistData->resume;
        if (file_exists($file)) {
            $headers = array('Content-Type: application/pdf');
            return Response::download($file, $therapistData->resume, $headers);
        } else {
            Session::flash('error', "لا توجد سيرة ذاتية ..يرجي ارفاقها");
            return back();
        }
    }

    //DownloadLicence
    public function downloadLicence($id)
    {
        $therapistData = Therapist::findOrFail($id);
        $file = public_path() . "/licences/" . $therapistData->licence;
        if (is_null($therapistData->licence)) {
            Session::flash('error', "لا توجد رخصة ..يرجي ارفاقها");
            return back();
        } else {
            return response()->download($file);
        }
    }


    //download Zip
    public function downloadCertificate($id)
    {
        $therapistData = Therapist::findOrFail($id);
        $file = public_path() . "/qualification/" . $therapistData->zip_certificates;
        if (is_null($therapistData->zip_certificates)) {
            Session::flash('error', "لا توجد شهادات ..يرجي ارفاقها");
            return back();
        } else {
            return response()->download($file);
        }
    }

    //viewToEdit
    public function viewToEdit($id)
    {
        $therapistData = Therapist::findOrFail($id);
        $userData = User::findOrFail($therapistData->user_id);
        return redirect('admin/system_users/' . $userData->id . '/edit');
    }
    public function notCompleted(Request $request)
    {
        if ($request->ajax()) {
            $therapists = User::select('users.*','therapists.mobile')->leftJoin('therapists', 'users.id', '=', 'therapists.user_id')->where('type', 'therapists')->whereNull('therapists.id');
            //dd($therapists->toSql());
            if (isset($request->order[0]['column']) && $request->order[0]['column'] == 6) {
                $therapists = $therapists->orderBy('active', $request->order[0]['dir']);
            }
            return DataTables::of($therapists)
                ->addIndexColumn()
                ->addColumn('checkbox', function ($therapist) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $therapist->id . '" class="therapistsCheckbox" type="checkbox" class="sub_chk"></div>';
                })
                ->addColumn('action', function ($therapist) {
                    return
                    '<a class="btn btn-danger sendEmailAgain" href="javascript:;" title="Send Complete Register Link" data-id="' . $therapist->user_id . '"><i class="fa fa-paper-plane" aria-hidden="true"></i>
                   </a>'
                    .'<a class="btn btn-primary copylink" href="javascript:;" title="Copy Complete Register Link" data-id="' . $therapist->id . '"><i class="fa fa-copy" aria-hidden="true"></i>
                    </a>'

                    .(($therapist->mobile)?'<a class="btn btn-success whatslink" href="javascript:;" title="what`s up" data-id="' . $therapist->id . '"><i class="fa fa-copy" aria-hidden="true"></i></a>':'')
                    ;

                })
                //         Send Link       ->addColumn('discount_code', function($sessionInfo){
                //                    return'';
                //                })
                ->rawColumns(['active', 'action', 'picture', 'resume', 'checkbox'])
                ->make(true);
        }
        return view('admin.therapists.view_not_completed');
    }
    public function sendEmail(Request $request)
    {
        if ($request->user_id) {

            $user = User::find($request->user_id);

            if ($user) {

                $user->send_register_link_date = date('Y-m-d H:i:s');
                $user->save();
                $html = view('email.sendverfyemail', compact('user'))->render();
                sendGridEmailToUser($html, $user->email, $user->name, 'Verified Email');
                return response()->json(['success' => true]);
            }
        }
        if ($request->ids && is_array($request->ids)) {
            $users = User::whereIn('id', $request->ids)->get();
            foreach ($users as $user) {
                $user->send_register_link_date = date('Y-m-d H:i:s');
                $user->save();
                $url= url("/verify/{$user->email}/{$user->verifyToken}");
                $html = view('email.sendverfyemail', compact('user','url'))->render();
                sendGridEmailToUser($html, $user->email, $user->name, 'Verified Email');
            }
            return response()->json(['success' => true]);
        }
        return abort(404);
    }





    public function copyemail(Request $request)
    {

        if ($request->user_id) {
            $therpist=Therapist::where('id',$request->user_id)->first();
            $user = User::find($therpist->user_id);
            if ($user) {
                $user->send_register_link_date = date('Y-m-d H:i:s');
                $user->save();
                $html = view('email.sendView', compact('user'))->render();

                return url("/verify/{$user->email}/{$user->verifyToken}");
            }
        }
        if ($request->ids && is_array($request->ids)) {
            $users = User::whereIn('id', $request->ids)->get();
            foreach ($users as $user) {
                $user->send_register_link_date = date('Y-m-d H:i:s');
                $user->save();
                $html = view('email.sendView', compact('user'))->render();
            }
               return url("/verify/{$user->email}/{$user->verifyToken}");
        }
        return abort(404);
    }


    public function whatslink(Request $request)
    {
        if ($request->user_id) {
            $user = User::find($request->user_id);
            if ($user) {
                $user->send_register_link_date = date('Y-m-d H:i:s');
                $user->save();
                $html = view('email.sendView', compact('user'))->render();

                return ($user->therapist)?'https://wa.me/2'.$user->therapist->mobile:'';
            }
        }
        if ($request->ids && is_array($request->ids)) {
            $users = User::whereIn('id', $request->ids)->get();
            foreach ($users as $user) {
                $user->send_register_link_date = date('Y-m-d H:i:s');
                $user->save();
                $html = view('email.sendView', compact('user'))->render();
            }
               return url("/verify/{$user->email}/{$user->verifyToken}");
        }
        return abort(404);
    }





    public function therapists_reset($id){

        $data['password']=Hash::make('123456');
        User::where('id',$id)->update($data);
        Session::flash('success', Lang::get('main.therapists') .' '. Lang::get('main.updatepass'));
        return Redirect::to('admin/therapists');
    }
    public function export()
    {
        $fileName = 'therapist_' . time();
        return Excel::download(new TherapistsExport, $fileName . '.xlsx');
    }
}
