<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Reviews;
use App\Therapist;
use Session;
use Validator;
use Lang;
use Yajra\DataTables\Facades\DataTables;
class AdminTherapistEvaluationController extends Controller
{

    public function index(Request $request)
    {
      /*  $allReviews = Reviews::with('ReQuestionAnswers')->get();
        return view('admin.evaluations.view',compact('allReviews'));*/

        if ($request->ajax()) {

            $allReviews=Reviews::with('ReQuestionAnswers')->with('therapist')->with('visitor');



           return DataTables::of($allReviews)
               ->addIndexColumn()



               ->addColumn('active', function ($allReviews) {
               })


               ->addColumn('action', function ($allReviews) {
                return '
        ' 
        // . (PerUser('evaluations_view') ? '<a class="btn btn-success" href="' . URL('admin/evaluations/' . $allReviews->id ) . '"><i class="fa fa-eye"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
        // ' 

        . (PerUser('evaluations_delete') ? '<a data-id="'.$allReviews->id.'" class="btn btn-danger delete_this" href="' . URL('evaluations_delete/'. $allReviews->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
        ';
            })
               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.evaluations.view');
    }

    public function create()
    {
        $users = Therapist::where('active',1)->get();
        return view('admin.evaluations.create',compact('users'));
    }


    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'therapist_id' => 'required',
                'rating' => 'required',
                'comment' => 'required',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $review = new Reviews();
            $review->therapist_id = $data['therapist_id'];
            $review->rating = $data['rating'];
            $review->comment = $data['comment'];
            $review->visitor_id = 0;
            $review->session_id = 0;
            $review->answer1 = 0;
            $review->answer2 = 0;
            $review->answer3 = 0;
            $review->answer4 = 0;
            $review->created_at = date("Y-m-d H:i:s");
            $review->updated_at = date("Y-m-d H:i:s");
            if ($review->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.evaluations'));
                return \Redirect::to('admin/evaluations/create');
            }
        }
    }



    public function show ($id)
    {
        $selectedReviews = Reviews::findOrFail($id);
        return view('admin.evaluations.display-evaluation',compact('selectedReviews'));
    }


    public function destroy($id)
    {
        $review = Reviews::findOrFail($id);
        !empty($review) ? $review->delete():'';
        return response()->json(['message' =>'Review Deleted Successfully']);
    }
}
