<?php

namespace App\Http\Controllers\Admin;

use App\Certificates;
use App\Countries;
use App\Education;
use App\Experience;
use App\Specialties;
use App\Therapist;
use App\Therapists_languages;
use App\TherapistsMainFocus;
use App\TherapistsSpecialties;
use App\Visitor;
use App\WebsiteLanguages;
use App\Languages;
use App\Profiles;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use App\TherapistsPictures;
use App\TherapistsRequests;
use App\Therapists_specialties;

class AdminTherapistRequstsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if ($request->ajax()) {
            /*    $therapists = TherapistsRequests::select('therapists_requests.id', 'therapists_requests.column_name', 'therapists_requests.from', 'therapists_requests.to', 'therapists_requests.therapists_id'
            , 'therapists.name_a', 'therapists.name_a', 'therapists.picture','therapists_specialties.therapist_id','therapists_specialties.speciality_id')
            ->leftJoin('therapists', 'therapists.id', '=', 'therapists_requests.therapists_id')
            ->leftJoin('therapists_specialties', 'therapists_specialties.therapist_id', '=', 'therapists_requests.therapists_id');


            $therapists = $therapists->where('therapists_requests.status', 'pending');
          //  $s = $therapists->where('therapists_requests.column_name', 'speciality_id')->get();

          foreach($therapists as $row){

            if( $row->column_name=='speciality_id'){
                  $therapists = Therapists_specialties::where('id',$row->speciality_id)->get();
              }

        }*/

            $therapists = TherapistsRequests::with('therapist')->with('therapistto')->with('languagefrom')->with('languageto')
                ->with('countaryfrom')->with('countaryto')
                ->where('status', 'pending');
            return DataTables::of($therapists)
                ->addIndexColumn()
                ->editColumn('to',function($therapist){
                    if($therapist->column_name=='speciality_id'){
                        $ids=json_decode($therapist->to);
                        if(!is_array($ids)){
                            $ids=[$ids];
                        }
                        return implode(',',Specialties::whereIn('id',$ids)->pluck('title_en')->toArray());
                    }
                    return$therapist->to;
                    return ($therapist->column_name=='speciality_id')?json_decode($therapist->to):$therapist->to;
                    return ($therapist->column_name=='speciality_id')?json_encode(Specialties::whereIn('id',json_decode($therapist->to))->pluck('name')->toArray()):$therapist->to;
                })
                ->addColumn('action', function ($therapist) {

                    return '
                        ' . (PerUser('therapistsrequests_approve') ? '<button  id="approve"class="btn btn-success" onclick="approve(' . $therapist->id . "," . "this" . ')"><i class="fa fa-check"></i>' ./*Lang::get('main.edit').*/ '</button>' : '') . '
                        ' . (PerUser('therapistsrequests_disapprove') ? '<button id="disapprove" class="btn btn-danger" onclick="disapprove(' . $therapist->id . "," . "this" . ')"><i class="fa fa-times"></i>' ./*Lang::get('main.edit').*/ '</button>' : '') . '

                                    ';
                })
                ->rawColumns(['action', 'picture'])
                ->make(true);
        }

        return view('admin.therapistsrequests.view');
    }


    public function edit($id)
    {

        // dd($id);

        $data['status'] = "approved";

        $request = TherapistsRequests::where('id', $id)->first();
        //dd($request);
        if($request->status =="pending"){
            $user = User::where('email', $request->from)->first();

            if($user =!null){
                $email['email'] = $request->to;
                User::where('email', $request->from)->update($email);
                $array=[];

                switch ($request->column_name){
                    case 'language_id':
                        $lang= therapists_languages::where('therapist_id',$request->therapists_id)->get();
                        if(count($lang) >0){
                            therapists_languages::where('therapist_id',$request->therapists_id)
                            ->update(['language_id'=>$request->to]);
                        }
                        else{
                            therapists_languages::create([
                                'therapist_id' => $request->therapists_id,
                                'language_id' => $request->to,
                            ]);
                        }
                        $array[$request->column_name]=$request->to;
                        Therapist::where('id', $request->therapists_id)->update($array);
                        break;
                    case 'speciality_id':
                        $spcilities=json_decode($request->to,true);
                        TherapistsSpecialties::where('therapist_id', $request->therapists_id)->delete();
                        for($i=0 ; $i<count($spcilities);$i++){

                            $speciality_id['speciality_id'] = $spcilities[$i];

                            $speciality_id['therapist_id'] = $request->therapists_id;
                            TherapistsSpecialties::create($speciality_id);
                        }

                        break;
                    case 'main_focus_ar':
                        $manFocusIDS=null;
                        if($request->ids){
                            $manFocusIDS=json_decode($request->ids);
                        }
                        if($manFocusIDS){
                            $ids=[];
                            foreach ($manFocusIDS as $main_focus_id){
                                $therapistsMainFocus=TherapistsMainFocus::where('therapist_id',$request->therapists_id)->where('main_focus_id',$main_focus_id)->first();
                                if(!$therapistsMainFocus){
                                    $therapistsMainFocus=new TherapistsMainFocus();
                                    $therapistsMainFocus->therapist_id=$request->therapists_id;
                                    $therapistsMainFocus->main_focus_id=$main_focus_id;
                                    $therapistsMainFocus->save();
                                }
                                $ids[]=$therapistsMainFocus->id;
                            }
                            TherapistsMainFocus::where('therapist_id',$request->therapists_id)->whereNotIn('id',$ids)->delete();
                        }
                        $array[$request->column_name]=$request->to;
                        Therapist::where('id', $request->therapists_id)->update($array);
                        break;
                    case 'main_focus_en':
                        $manFocusIDS=null;
                        if($request->ids){
                            $manFocusIDS=json_decode($request->ids);
                        }
                        if($manFocusIDS){
                            $ids=[];
                            foreach ($manFocusIDS as $main_focus_id){
                                $therapistsMainFocus=TherapistsMainFocus::where('therapist_id',$request->therapists_id)->where('main_focus_id',$main_focus_id)->first();
                                if(!$therapistsMainFocus){
                                    $therapistsMainFocus=new TherapistsMainFocus();
                                    $therapistsMainFocus->therapist_id=$request->therapists_id;
                                    $therapistsMainFocus->main_focus_id=$main_focus_id;
                                    $therapistsMainFocus->save();
                                }
                                $ids[]=$therapistsMainFocus->id;
                            }
                            TherapistsMainFocus::where('therapist_id',$request->therapists_id)->whereNotIn('id',$ids)->delete();
                        }
                        $array[$request->column_name]=$request->to;
                        Therapist::where('id', $request->therapists_id)->update($array);
                        break;
                    default:
                        $array[$request->column_name]=$request->to;
                        Therapist::where('id', $request->therapists_id)->update($array);
                        break;
                }

                TherapistsRequests::where('id', $id)->update($data);
               return response()->json(['success'=>true]);

            }
            return response()->json(['success'=>false]);
        }else{
            return 'error';
            Session::flash('success', 'الطلب غير متاح حاليا');
        }
    }


    public function disapprove($id)
    {
        $request = TherapistsRequests::where('id', $id)->first();
        if($request->status =="pending"){
            $data['status'] = "admin_canceled";
            TherapistsRequests::where('id', $id)->update($data);

            return redirect()->back()->withErrors(['error' => trans('home.Sessions-canceld-successfully')]);
        }else{
            return 'error';
        }

    }


    public function search(Request $request,$id)
    {
        //  dd($id);

        if ($request->ajax()) {
            $therapists = TherapistsRequests::with('therapist')->with('therapistto')->with('languagefrom')->with('languageto')
                ->with('countaryfrom')->with('countaryto');

            $therapists=$therapists->where('id', $id);
            return DataTables::of($therapists)
                ->addIndexColumn()
                ->addColumn('action', function ($therapists) {

                    return '
                ' . (PerUser('therapistsrequests_approve') ? '<button  id="approve"class="btn btn-success" onclick="approve(' . $therapists->id . "," . "this" . ')"><i class="fa fa-check"></i>' ./*Lang::get('main.edit').*/ '</button>' : '') . '
                ' . (PerUser('therapistsrequests_disapprove') ? '<button id="disapprove" class="btn btn-danger" onclick="disapprove(' . $therapists->id . "," . "this" . ')"><i class="fa fa-times"></i>' ./*Lang::get('main.edit').*/ '</button>' : '') . '

                            ';
                })
                ->rawColumns(['action', 'picture'])
                ->make(true);
        }

        return view('admin.therapistsrequests.search');



    }
}
