<?php

namespace App\Http\Controllers\Admin;

use App\Videos;
use App\WebsiteLanguages;
use App\Profiles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
class AdminVideosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      /*  $search=$request->input('search');
        if($search){
            $videos=Videos::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $videos=Videos::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.videos.view',compact('videos'));*/

        if ($request->ajax()) {

            $videos=Videos::orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $videos = $videos->where('active', 1);
                       break;
                   case 'unactive':
                       $videos = $videos->where('active', 0);
                       break;
               }
           }

           return DataTables::of($videos)
               ->addIndexColumn()

               ->addColumn('active', function ($video) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $video->id . '" type="checkbox" ' . (!PerUser('videos_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('videos_active') ? 'changeStatues' : '') . '"  ' . (($video->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $video->id . '"><label for="checkbox-' . $video->id . '"></label></div>';
               })
               ->addColumn('action', function ($video) {
                   return '
           ' . (PerUser('videos_edit') ? '<a class="btn btn-success" href="' . URL('admin/videos/' . $video->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('videos_delete') ? '<a class="btn btn-danger" href="' . URL('videos_delete/'. $video->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.videos.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages = WebsiteLanguages::orderBy('default','desc')->get();
        return view('admin.videos.add',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'name'=>'required',
                'iframe'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active=(isset($data['active']))?1:0;
            $videos=new Videos();
            $videos->name=$data['name'];
            $videos->iframe=$data['iframe'];
            $videos->sort=$data['sort'];
            $videos->active=$active;
            $videos->user_id=Auth::user()->id;
            $videos->created_at=date("Y-m-d H:i:s");
            if($videos->save()){
//                save_all_trans($data,$videos->id,'videos',['title'=>'titles','description'=>'descriptions']);
                Session::flash('success', Lang::get('main.insert').Lang::get('main.videos'));
                return Redirect::to('admin/videos/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Videos  $video
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Videos  $video
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages = get_language_trans($id,'videos');
        $video=Videos::find($id);
        if(!empty($video)){
            return view('admin.videos.edit',compact('video','languages'));
        }else{
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Videos  $video
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $videos= Videos::find($id);
        if(!empty($videos)){
            $validator = Validator::make($request->all(),
                array(
                    'name'=>'required',
                    'iframe'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                $active=(isset($data['active']))?1:0;
                $videos->name=$data['name'];
                $videos->iframe=$data['iframe'];
                $videos->sort=$data['sort'];
                $videos->active=$active;
                $videos->user_id=Auth::user()->id;
                $videos->updated_at=date("Y-m-d H:i:s");
                if($videos->save()){
//                    save_all_trans($data,$id,'videos',['title'=>'titles','description'=>'descriptions']);
                    Session::flash('success', Lang::get('main.update').Lang::get('main.videos'));
                    return Redirect::to('admin/videos/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Videos  $video
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $videos=Videos::find($id);
        if(!empty($videos)){
//            $videos->deleted_by=Auth::user()->id;
            $videos->save();
            if($videos->delete()){
                Session::flash('success', Lang::get('main.videos') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/videos');
            }
        }
    }

    public function activation(Request $request){
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $video=Videos::find($id);
            if ($active == 0) {
                $video->active = 0;
            } elseif ($active == 1) {
                $video->active = 1;
            }
            $video->save();
        }else{
            return redirect(404);
        }
    }
}
