<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Visitor;
use App\User;
use Illuminate\Http\Request;
use DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class AdminVisitorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
            if ($request->ajax()) {
                $visitors=Visitor::Join('users', 'visitors.user_id', '=', 'users.id')->select(['users.id','users.name', 'users.email', 'visitors.gender', 'visitors.mobile',
                    'visitors.birthyear','visitors.user_id',
                ]);
                //dd(getEloquentSqlWithBindings($visitors));
                return DataTables::of($visitors)
                    ->addIndexColumn()
                    ->addColumn('action', function($visitor){
                        $url = url('admin/visitors/'.$visitor->id.'/edit');
                        $url2 = url('visitors_reset/'.$visitor->user_id);
                        $btn ='<a href="'.$url.'" class="edit btn btn-primary btn-sm">Edit</a>';
                        $btn =$btn.'<a href="'.$url2.'" class=" btn btn-success btn-sm">reset pass</a>';
                        $btn = $btn.'<a href="javascript:void(0)" class="delete_this btn btn-danger btn-sm" data-id="'.$visitor->id.'">Delete</a>';
                        return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }

        return view('admin.visitors.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $users = User::where(['type'=>'visitors','active'=>0])->pluck('name','id');
        return view('admin.visitors.add',compact('users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = User::findorFail($request->user_id);
        $user->active = 1;
        $user->save();
        $visitorData = Visitor::create(['user_id'=>$user->id,'gender'=>$request->gender,'mobile'=>$request->mobile,'birthyear'=>$request->birthyear]);
        Session::flash('success', Lang::get('main.insert').Lang::get('main.users'));
        return Redirect::to('admin/visitors');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
//        dd($id);
        $user = User::findOrFail($id);
//        dd($userData);
        return view('admin.visitors.edit',compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->visitor->delete();
        $user->delete();
        return response()->json('Visitor Deleted Successfully');
    }

    public function visitors_reset($id){

        $data['password']=Hash::make('123456');
        User::where('id',$id)->update($data);
        Session::flash('success', Lang::get('main.visitors') .' '. Lang::get('main.updatepass'));
        return Redirect::to('admin/visitors');
    }
}
