<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\WebsiteRating;
use Yajra\DataTables\Facades\DataTables;
class AdminWebsiteComment extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

       /* $search=$request->input('search');
        if($search){
            $comments=WebsiteRating::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
        }else{
            $comments=WebsiteRating::orderBy('id','DESC')->paginate(100);
        }
        return view('admin.comments.view',compact('comments'));*/

        if ($request->ajax()) {

            $comments=WebsiteRating::with('user')->orderBy('id','DESC');


           if ($request->active) {
               switch ($request->active) {
                   case 'active':
                       $comments = $comments->where('active', 1);
                       break;
                   case 'unactive':
                       $comments = $comments->where('active', 0);
                       break;
               }
           }

           return DataTables::of($comments)
               ->addIndexColumn()


               ->addColumn('user', function ($comments) {
                   return ($comments->user)?$comments->user->name:'';
               })
               ->addColumn('active', function ($comments) {
                   return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $comments->id . '" type="checkbox" ' . (!PerUser('comment_view') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('comment_view') ? 'changeStatues' : '') . '"  ' . (($comments->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $comments->id . '"><label for="checkbox-' . $comments->id . '"></label></div>';
               })
               ->addColumn('action', function ($comments) {
                   return '
           ' . (PerUser('comment_delete') ? '<a class="btn btn-danger" href="javascript:;" class="delete_this" data-id="' . $comments->id . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
               })

               ->rawColumns(['active', 'action'])
               ->make(true);
       }
       return view('admin.comments.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $comment = WebsiteRating::findOrFail($id);
        !empty($comment) ? $comment->delete():'';
        return "Comment Deleted Success";
    }

    public function activation(Request $request)
    {
        if($request->ajax()){
            $id=$request->input('id');
            $active=$request->input('active');
            $comment=WebsiteRating::findOrFail($id);
            if ($active == 0) {
                $comment->active = 0;
            } elseif ($active == 1) {
                $comment->active = 1;
            }
            $comment->save();
            return "Comment Active Success";
        }else{
            return redirect(404);
        }
    }

}
