<?php

namespace App\Http\Controllers\Admin;

use App\Coupons;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use App\Therapist;

class CouponsController extends Controller

{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /* $search=$request->input('search');
         if($search){
             $coupons=Coupons::where('title_ar','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
         }else{
             $coupons=Coupons::orderBy('id','DESC')->paginate(100);
         }
         return view('admin.coupons.view',compact('coupons'));*/
        if ($request->ajax()) {

            $coupons=Coupons::orderBy('id','DESC');

            return DataTables::of($coupons)
                ->addIndexColumn()

                ->addColumn('action', function ($coupons) {
                    return '
           ' . (PerUser('coupons_edit') ? '<a class="btn btn-success" href="' . URL('admin/coupons/' . $coupons->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
           ' . (PerUser('coupons_delete') ? '<a class="btn btn-danger" href="' . URL('coupons_delete/'. $coupons->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
           ';
                })
                ->addColumn('therapists', function ($coupons) {
                    $array = '';
                    foreach(explode(',',$coupons->therapists) as $info)
                    {
                        if($info)
                        {
                            $therapist = Therapist::find($info);
                            $array .= $therapist->name_e.' & ';
                        }
                        
                    }
                    return $array;
                    
                })



                ->rawColumns(['active', 'action'])
                ->make(true);
        }
        return view('admin.coupons.view');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $therapists = Therapist::where('active', 1)->get();
        return view('admin.coupons.add', compact('therapists'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'type'=>'required',
                'used_for_session'=>'required',
                'percentage'=>'required',
                'code'=>'required',
                'per_user'=>'required',
                'used_limit'=>'required',
                'expired_date'=>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {

            if($request->therapists)
            {
                $therapists = implode(',', $request->therapists);
            }
            else
            {
                $therapists = '';
            }
            

            $data = [
                'type' => $request->type,
                'used_for_session' => $request->used_for_session,
                'percentage' => $request->percentage,
                'code' => $request->code,
                'per_user' => $request->per_user,
                'used_limit' => $request->used_limit,
                'currency' => $request->currency,
                'expired_date' => $request->expired_date,
                'therapists' => $therapists,
            ];

            Coupons::create($data);
            Session::flash('success', Lang::get('main.insert').Lang::get('main.coupons'));
            return Redirect::to('admin/coupons/create');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Coupons  $country
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Coupons  $country
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $therapists = Therapist::where('active', 1)->get();
        $coupon=Coupons::find($id);
        if($coupon){
            return view('admin.coupons.edit',compact('coupon','therapists'));
        }
        return abort(404);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Coupons  $country
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $coupons= Coupons::find($id);
        if(!empty($coupons)){
            $validator = Validator::make($request->all(),
                array(
                    'type'=>'required',
                    'used_for_session'=>'required',
                    'percentage'=>'required',
                    'code'=>'required',
                    'per_user'=>'required',
                    'used_limit'=>'required',
                    'expired_date'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {

                if($request->therapists)
                {
                    $therapists = implode(',', $request->therapists);
                }
                else
                {
                    $therapists = '';
                }

                $data = [
                    'type' => $request->type,
                    'used_for_session' => $request->used_for_session,
                    'percentage' => $request->percentage,
                    'code' => $request->code,
                    'per_user' => $request->per_user,
                    'used_limit' => $request->used_limit,
                    'currency' => $request->currency,
                    'expired_date' => $request->expired_date,
                    'therapists' => $therapists,
                ];

                Coupons::where('id',$id)->update($data);
                Session::flash('success', Lang::get('main.update').Lang::get('main.coupons'));
                return Redirect::to('admin/coupons/'.$id.'/edit');
            }
        }else{
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Coupons  $country
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $coupons=Coupons::find($id);
        if(!empty($coupons)){
//            $coupons->deleted_by=Auth::user()->id;
            $coupons->save();
            if($coupons->delete()){
                Session::flash('success', Lang::get('main.coupons') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/coupons');
            }
        }
    }
}
