<?php

namespace App\Http\Controllers\Admin;

use App\WebsiteLanguages;
use App\Profiles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Yajra\DataTables\Facades\DataTables;

class ProfilesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        /*  $data=$request->input();
        $search=$request->input('search');
        if($search){
            $profiles=Profiles::where('name','LIKE',"%$search%")->orderBy('id','DESC')->paginate(100);
            $profiles->Profiles(['search'=>$search]);
        }else{
            $profiles=Profiles::orderBy('system_profiles.id','DESC')->get();
        }*/

        if ($request->ajax()) {
            $profiles = Profiles::orderBy('system_profiles.id', 'DESC');


            if ($request->active) {
                switch ($request->active) {
                    case 'active':
                        $profiles = $profiles->where('active', 1);
                        break;
                    case 'unactive':
                        $profiles = $profiles->where('active', 0);
                        break;
                }
            }

            return DataTables::of($profiles)
                ->addIndexColumn()

                ->addColumn('active', function ($profile) {
                    return '<div class="checkbox-nice checkbox-inline"><input data-id="' . $profile->id . '" type="checkbox" ' . (!PerUser('profiles_active') ? 'disabled="disabled"' : '') . '   class="' . (PerUser('profiles_active') ? 'changeStatues' : '') . '"  ' . (($profile->active == 1) ? 'checked="checked"' : '') . ' id="checkbox-' . $profile->id . '"><label for="checkbox-' . $profile->id . '"></label></div>';
                })
                ->addColumn('action', function ($profile) {
                    return '
                    ' . (PerUser('profiles_edit') ? '<a class="btn btn-success" href="' . URL('admin/profiles/' . $profile->id . '/edit') . '"><i class="fa fa-pencil"></i>' ./*Lang::get('main.edit').*/ '</a>' : '') . '
                    ' . (PerUser('profiles_delete') ? '<a class="btn btn-danger" href="' . URL('profiles_delete/'. $profile->id) . '"><i class="fa fa-trash-o"></i>' ./*Lang::get('main.delete').*/ '</a>' : '') . '
                    ';
                })

                ->rawColumns(['active', 'action'])
                ->make(true);
        }

        return view('admin.profiles.view');


        // return view('admin.profiles.view',compact('profiles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.profiles.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $data = $request->input();
        $validator = Validator::make(
            $request->all(),
            array(
                'name' => 'required',
                'permissions' => 'required'
            )
        );
        $permissions = (!isset($data['permissions'])) ? [] : $data['permissions'];
        $arr = [];
        foreach ($GLOBALS['permissions_settings'] as $pr) {
            if (in_array($pr, $permissions)) {
                $arr[$pr] = 1;
            } else {
                $arr[$pr] = 0;
            }
        }
        $perm = json_encode($arr);
        $validator->after(function () use ($validator, $data, $perm) {
            $per = json_decode($perm);
            $report = array();
            $y = 1;
            foreach ($GLOBALS['sup_permissions'] as $sup => $val) {
                if ($per->$sup) {
                    foreach ($val as $v) {
                        if ($per->$v) {
                            $report[$sup][] = 1;
                        } else {
                            $report[$sup][] = 0;
                        }
                        $y++;
                    }
                }
            }
            if (empty($report)) {
                $validator->errors()->add('error_permissions', Lang::get('main.error_profiles_child_select_message'));
            }
            foreach ($report as $re) {
                if (!in_array('1', $re)) {
                    $validator->errors()->add('error_permissions', Lang::get('main.error_profiles_parent_select_message'));
                    break;
                }
            }
        });
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $profiles = new Profiles();
            $profiles->name = $data['name'];
            $profiles->permissions = $perm;
            $profiles->active = $active;
            if ($active == 1) {
                $profiles->active_by = Auth::user()->id;
                $profiles->active_date = date("Y-m-d H:i:s");
            }
            if ($active == 0) {
                $profiles->unactive_by = Auth::user()->id;
                $profiles->unactive_date = date("Y-m-d H:i:s");
            }
            $profiles->add_by = Auth::user()->id;
            $profiles->add_date = date("Y-m-d H:i:s");
            if ($profiles->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.profiles'));
                return Redirect::to('admin/profiles/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $post = Profiles::find($id);
        if (!empty($post)) {
            $post = makeDefaultImage($post, 'profiles');
            return view('admin.profiles.edit', compact('post'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->input();
        $profiles = Profiles::find($id);
        if (!empty($profiles)) {
            $validator = Validator::make(
                $request->all(),
                array(
                    'name' => 'required',
                    'permissions' => 'required',
                )
            );
            $permissions = (!isset($data['permissions'])) ? [] : $data['permissions'];
            $arr = [];
            foreach ($GLOBALS['permissions_settings'] as $pr) {
                if (in_array($pr, $permissions)) {
                    $arr[$pr] = 1;
                } else {
                    $arr[$pr] = 0;
                }
            }
            $perm = json_encode($arr);
            $validator->after(function () use ($validator, $data, $perm) {
                $per = json_decode($perm);
                $report = array();
                $y = 1;
                foreach ($GLOBALS['sup_permissions'] as $sup => $val) {
                    if ($per->$sup) {
                        foreach ($val as $v) {
                            if ($per->$v) {
                                $report[$sup][] = 1;
                            } else {
                                $report[$sup][] = 0;
                            }
                            $y++;
                        }
                    }
                }
                if (empty($report)) {
                    $validator->errors()->add('error_permissions', Lang::get('main.error_profiles_child_select_message'));
                }
                foreach ($report as $re) {
                    if (!in_array('1', $re)) {
                        $validator->errors()->add('error_permissions', Lang::get('main.error_profiles_parent_select_message'));
                        break;
                    }
                }
            });
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            } else {
                $active = (isset($data['active'])) ? 1 : 0;
                $profiles->name = $data['name'];
                $profiles->permissions = $perm;
                if ($active == 1 && $profiles->active == 0) {
                    $profiles->active_by = Auth::user()->id;
                    $profiles->active_date = date("Y-m-d H:i:s");
                }
                if ($active == 0 && $profiles->active == 1) {
                    $profiles->unactive_by = Auth::user()->id;
                    $profiles->unactive_date = date("Y-m-d H:i:s");
                }
                $profiles->active = $active;
                $profiles->lastedit_by = Auth::user()->id;
                $profiles->lastedit_date = date("Y-m-d H:i:s");
                if ($profiles->save()) {
                    Session::flash('success', Lang::get('main.update') . Lang::get('main.profiles'));
                    return Redirect::to('admin/profiles/' . $id . '/edit');
                }
            }
        } else {
            return abort(404);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $profiles = Profiles::find($id);

        if (!empty($profiles)) {
            $profiles->deleted_by = Auth::user()->id;
            $profiles->save();
            if ($profiles->delete()) {
                Session::flash('success', Lang::get('main.profiles') .' '. Lang::get('main.delete'));
                return Redirect::to('admin/profiles');
            }
        }
    }
    public function activation(Request $request)
    {


        if ($request->ajax()) {

            $id = $request->input('id');
            $active = $request->input('active');
            $profiles = Profiles::find($id);
            if ($active == 0) {
                $profiles->active = 0;
                $profiles->unactive_by = Auth::user()->id;
                $profiles->unactive_date = date("Y-m-d H:i:s");
            } elseif ($active == 1) {
                $profiles->active = 1;
                $profiles->active_by = Auth::user()->id;
                $profiles->active_date = date("Y-m-d H:i:s");
            }
            $profiles->save();
        } else {
            return redirect(404);
        }
    }
}
