<?php

namespace App\Http\Controllers\Admin;

use App\Profiles;
use App\Therapist;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;

class SystemUsersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $data=$request->input();
        $search=$request->input('search');
        if($search){
            $system_users=User::where('name','LIKE',"%$search%")->orderBy('id','DESC')->where('id','!=',Auth::user()->id)->where('id','!=',1)->paginate(100);
            $system_users->User(['search'=>$search]);
        }else{
            $system_users=User::orderBy('users.id','DESC')->where('id','!=',Auth::user()->id)->where('id','!=',1)->get();
        }
        return view('admin.system_users.view',compact('system_users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.system_users.add');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'name'=>'required',
                'email'=>'required|unique:users,email',
                'password'=>'required',
                'confirm_password'=>'required|same:password',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $system_users=new User();
            $system_users->name=$data['name'];
            $system_users->email=$data['email'];
            $system_users->type=$data['type'];
            $system_users->password=Hash::make($data['password']);
            $system_users->created_at=date("Y-m-d H:i:s");
            if($system_users->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('main.users'));
                return Redirect::to('admin/system_users/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = User::findOrFail($id);
        return view('admin.system_users.edit',compact('post'));
    }

    //view as therapist or visitor
    public function ViewInformation($id)
    {
        $user = User::findOrFail($id);
        if($user->type == "therapists")
        {
            $therapistInfo = Therapist::where('user_id',$user->id)->first();
            if(is_null($therapistInfo))
            {
                session::flash('status',trans('home.no-therapist-found'));
                return back();
            }
            else
            {
                return redirect('admin/therapists/'.$therapistInfo->id.'/edit');
            }
        }
        else
        {
            return "visitor";
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $system_users= User::find($id);
        if(!empty($system_users)){
            $validator = Validator::make($request->all(),
                array(
                    'name'=>'required',
                    'email'=>'required|unique:users,email,'.$id,
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                if(!empty($data['password'])){
                    $validator = Validator::make($request->all(),
                        array(
                            'password'=>'required|min:6',
                            'confirm_password'=>'required|same:password',
                        ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }else {
                        $system_users->password=Hash::make($data['password']);
                    }
                }
                $system_users->name=$data['name'];
                $system_users->email=$data['email'];
                $system_users->type=$data['type'];
                $system_users->updated_at=date("Y-m-d H:i:s");
                if($system_users->save()){
                    Session::flash('success', Lang::get('main.update').Lang::get('main.users'));
                    return Redirect::to('admin/system_users/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $system_users=User::find($id);
        if(!empty($system_users)){
//            $system_users->deleted_by=Auth::user()->id;
            $system_users->save();
            if($system_users->delete()){

            }
        }
    }
}
