<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Exceptions\JWTException;

class ApiController extends Controller
{
    public function returnJsonResponse($message, $data = [], $status = TRUE, $response = Response::HTTP_OK)
    {
        $json=[
            'message'           =>$message,
            'status'            =>$status,
        ];
        if((is_array($data)&&count($data))||!is_array($data)){
            $json['data']=$data;
        }
        return response()->json($json, $response)
            ->header('Access-Control-Allow-Origin', '*')
            ->header('Content-Type', 'application/json;charset=UTF-8')
            ->header('Access-Control-Allow-Methods', 'POST, GET, PATCH, PUT')
            ->header('Charset', 'utf-8');
    }
    public function generateRandomString($length = 10,$small_letters='all',$capital_letters='all')
    {
        $characters = '0123456789';
        if($small_letters=='all') {
            $characters .= 'abcdefghijklmnopqrstuvwxy';
        }
        if($capital_letters=='all'){
            $characters .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        }

        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}
